/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.dao;

import com.querydsl.core.QueryResults;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.huiche.dao.Dao;
import org.huiche.dao.IdInfo;
import org.huiche.dao.operation.CrudOperation;
import org.huiche.dao.support.PageImpl;
import org.huiche.dao.support.Query;
import org.huiche.dao.support.Querys;
import org.huiche.domain.Page;
import org.huiche.domain.Pageable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;

public abstract class AbstractCrudDao<T>
extends Dao
implements CrudOperation<T> {
    @Autowired
    protected RelationalPath<T> table;

    @Override
    public boolean exists(Predicate ... conditions) {
        return Objects.equals(1, this.addWhere((SQLQuery)this.sql.selectOne().from(this.table), conditions).fetchFirst());
    }

    protected <R> SQLQuery<R> addWhere(SQLQuery<R> query, Predicate ... conditions) {
        if (conditions.length > 0) {
            query.where(conditions);
        }
        return query;
    }

    @Override
    public T getOne(Predicate ... conditions) {
        return (T)this.addWhere(this.sql.selectFrom(this.table), conditions).fetchOne();
    }

    @Override
    public <Col> Col getColumnOne(Expression<Col> column, Predicate ... conditions) {
        return (Col)this.addWhere((SQLQuery)this.sql.select(column).from(this.table), conditions).fetchOne();
    }

    @Override
    public T getColumnsOne(Expression<?>[] columns, Predicate ... conditions) {
        return (T)this.addWhere((SQLQuery)this.sql.select((Expression)Projections.fields(this.table, columns)).from(this.table), conditions).fetchOne();
    }

    @Override
    public <DTO> DTO getDtoOne(Class<DTO> dtoClass, Expression<?>[] columns, Predicate ... conditions) {
        return (DTO)this.addWhere((SQLQuery)((SQLQuery)this.sql.select((Expression)Projections.fields(dtoClass, columns)).from(this.table)).where(new Predicate[0]), conditions).fetchOne();
    }

    @Override
    public T getFirst(Query query) {
        return (T)query.use(this.sql.selectFrom(this.table)).fetchFirst();
    }

    @Override
    public <Col> Col getColumnFirst(Expression<Col> column, Query query) {
        return (Col)query.use((SQLQuery)this.sql.select(column).from(this.table)).fetchFirst();
    }

    @Override
    public T getColumnsFirst(Expression<?>[] columns, Query query) {
        return (T)query.use((SQLQuery)this.sql.select((Expression)Projections.fields(this.table, columns)).from(this.table)).fetchFirst();
    }

    @Override
    public <DTO> DTO getDtoFirst(Class<DTO> dtoClass, Expression<?>[] columns, Query query) {
        return (DTO)query.use((SQLQuery)this.sql.select((Expression)Projections.fields(dtoClass, columns)).from(this.table)).fetchFirst();
    }

    @Override
    public List<T> list(T query) {
        return this.list((T)Querys.ofEntity(query, this.table));
    }

    @Override
    public List<T> list(Query query) {
        return query.use(this.sql.selectFrom(this.table)).fetch();
    }

    @Override
    public <Col> List<Col> listColumn(Path<Col> column, Query query) {
        return query.use((SQLQuery)this.sql.select(column).from(this.table)).fetch();
    }

    @Override
    public List<T> listColumns(Expression<?>[] columns, Query query) {
        return query.use((SQLQuery)this.sql.select((Expression)Projections.fields(this.table, columns)).from(this.table)).fetch();
    }

    @Override
    public <DTO> List<DTO> listDto(Class<DTO> dtoClass, Expression<?>[] columns, Query query) {
        return query.use((SQLQuery)this.sql.select((Expression)Projections.fields(dtoClass, columns)).from(this.table)).fetch();
    }

    @Override
    public long delete(Predicate ... conditions) {
        SQLDeleteClause dml = this.sql.delete(this.table);
        if (conditions.length > 0) {
            dml.where(conditions);
        }
        return dml.execute();
    }

    @Override
    public long count(Predicate ... conditions) {
        return this.addWhere((SQLQuery)this.sql.selectOne().from(this.table), conditions).fetchCount();
    }

    @Override
    public long update(@Nullable T entityUpdate, @Nullable Consumer<SQLUpdateClause> setter, Predicate ... conditions) {
        entityUpdate = this.beforeUpdate(entityUpdate);
        SQLUpdateClause dml = this.sql.update(this.table);
        if (entityUpdate != null) {
            dml.populate(entityUpdate);
        }
        if (conditions.length > 0) {
            dml.where(conditions);
        }
        if (setter != null) {
            setter.accept(dml);
        }
        return dml.execute();
    }

    protected long autoIncrementIdsExecuteAndSet(SQLInsertClause dml, IdInfo idInfo, List<T> entityList) {
        LinkedList ids = new LinkedList(dml.executeWithKeys(idInfo.getPath()));
        int insertSize = ids.size();
        entityList.forEach(entity -> idInfo.setIdVal(entity, ids.poll()));
        return insertSize;
    }

    @Override
    public long count(T query) {
        return this.count(Querys.ofEntity(query, this.table));
    }

    @Override
    public Page<T> page(Pageable pageable, T query) {
        return this.page(Query.of(pageable).where(Querys.ofEntity(query, this.table)));
    }

    @Override
    public Page<T> page(Query query) {
        return PageImpl.of(query.getPageable(), query.useForPage(this.sql.selectFrom(this.table)).fetchResults());
    }

    @Override
    public Page<T> pageColumns(Expression<?>[] columns, Query query) {
        return PageImpl.of(query.getPageable(), query.useForPage((SQLQuery)this.sql.select((Expression)Projections.fields(this.table, columns)).from(this.table)).fetchResults());
    }

    @Override
    public <DTO> Page<DTO> pageDto(Class<DTO> dtoClass, Expression<?>[] columns, Query query) {
        return PageImpl.of(query.getPageable(), query.useForPage((SQLQuery)this.sql.select((Expression)Projections.fields(dtoClass, columns)).from(this.table)).fetchResults());
    }

    @Override
    public <DTO> Page<DTO> pageDto(Function<Tuple, DTO> mapper, Expression<?>[] columns, Query query) {
        return PageImpl.of(query.getPageable(), (QueryResults<Tuple>)query.useForPage((SQLQuery)this.sql.select(columns).from(this.table)).fetchResults(), mapper);
    }
}

