/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.huiche.exception.HcException;
import org.huiche.support.LambdaMethod;
import org.huiche.support.SerializableFunction;

public interface ReflectUtil {
    public static final Logger LOGGER = Logger.getLogger(ReflectUtil.class.getName());

    public static Set<Class<?>> scanClassInJar(ClassLoader classLoader, String scanPackage, Predicate<Class<?>> filter) {
        HashSet classes = new HashSet();
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                String path = resource.getPath();
                if (!path.startsWith("jar:file")) continue;
                path = path.substring(6, path.length() - 22);
                classes.addAll(ReflectUtil.scanClassInJar(new File(path), scanPackage, filter));
            }
        }
        catch (IOException e) {
            ReflectUtil.logException(e);
        }
        return classes;
    }

    private static Set<Class<?>> scanClassInJar(File file, String scanPackage, Predicate<Class<?>> filter) throws IOException {
        HashSet classes = new HashSet();
        if (file.exists() && file.isFile() && file.getName().endsWith(".jar")) {
            try (JarFile jarFile = new JarFile(file);){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String className;
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || name.startsWith("META-INF") || !name.endsWith(".class") || !ReflectUtil.isPackageMatch(className = name.replaceAll("/", ".").substring(0, name.length() - 6), scanPackage)) continue;
                    classes.addAll(ReflectUtil.loadClass(className, filter));
                }
            }
        }
        return classes;
    }

    public static Set<Class<?>> scanClass(String scanPackage, Predicate<Class<?>> filter) {
        return ReflectUtil.scanClass(Thread.currentThread().getContextClassLoader(), scanPackage, filter);
    }

    public static Set<Class<?>> scanClass(ClassLoader classLoader, String scanPackage, Predicate<Class<?>> filter) {
        HashSet classes = new HashSet();
        classes.addAll(ReflectUtil.scanClassInSrc(classLoader, scanPackage, filter));
        classes.addAll(ReflectUtil.scanClassInJar(classLoader, scanPackage, filter));
        return classes;
    }

    public static Set<Class<?>> scanClassInSrc(ClassLoader classLoader, String scanPackage, Predicate<Class<?>> filter) {
        HashSet classes = new HashSet();
        try {
            Enumeration<URL> resources = classLoader.getResources(".");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                File file = new File(resource.getFile());
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    if (files == null) continue;
                    for (File f : files) {
                        if (f.isDirectory()) {
                            String packageName = f.getName();
                            if (!ReflectUtil.isPackageMatch(packageName, scanPackage)) continue;
                            classes.addAll(ReflectUtil.scanClassInDir(f, packageName, scanPackage, filter));
                            continue;
                        }
                        if (!ReflectUtil.isPackageMatch("", scanPackage)) continue;
                        classes.addAll(ReflectUtil.loadClass(f, "", filter));
                    }
                    continue;
                }
                if (!ReflectUtil.isPackageMatch("", scanPackage)) continue;
                classes.addAll(ReflectUtil.loadClass(file, "", filter));
            }
        }
        catch (IOException e) {
            ReflectUtil.logException(e);
        }
        return classes;
    }

    private static boolean isPackageMatch(String packageName, String scanPackage) {
        if (scanPackage == null || scanPackage.isEmpty()) {
            return true;
        }
        return packageName.startsWith(scanPackage) || scanPackage.startsWith(packageName);
    }

    private static Set<Class<?>> loadClass(File file, String packageName, Predicate<Class<?>> filter) {
        String fileName = file.getName();
        if (fileName.endsWith(".class")) {
            String className = packageName + "." + fileName.substring(0, fileName.length() - 6);
            return ReflectUtil.loadClass(className, filter);
        }
        return Collections.emptySet();
    }

    private static Set<Class<?>> loadClass(String className, Predicate<Class<?>> filter) {
        try {
            Class<?> clazz = Class.forName(className);
            if (filter.test(clazz)) {
                return Collections.singleton(clazz);
            }
        }
        catch (Error clazz) {
        }
        catch (Exception e) {
            ReflectUtil.logException(e);
        }
        return Collections.emptySet();
    }

    private static void logException(Throwable e) {
        LOGGER.warning(() -> {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        });
    }

    private static Set<Class<?>> scanClassInDir(File dir, String packageName, String scanPackage, Predicate<Class<?>> filter) {
        HashSet classes = new HashSet();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    if (!ReflectUtil.isPackageMatch(packageName + "." + file.getName(), scanPackage)) continue;
                    classes.addAll(ReflectUtil.scanClassInDir(file, packageName + "." + file.getName(), scanPackage, filter));
                    continue;
                }
                if (!ReflectUtil.isPackageMatch(packageName, scanPackage)) continue;
                classes.addAll(ReflectUtil.loadClass(file, packageName, filter));
            }
        }
        return classes;
    }

    public static Class<?> getGenericsClass(Class<?> clazz) {
        for (Type t : clazz.getGenericInterfaces()) {
            if (!(t instanceof ParameterizedType)) continue;
            ParameterizedType pt = (ParameterizedType)t;
            for (Type at : pt.getActualTypeArguments()) {
                if (!(at instanceof Class)) continue;
                Class ct = (Class)at;
                return ct;
            }
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null && superClazz != Objects.class) {
            return ReflectUtil.getGenericsClass(superClazz);
        }
        return null;
    }

    public static ParameterizedType parameterizedType(final Class<?> raw, final Type ... args) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return args;
            }

            @Override
            public Type getRawType() {
                return raw;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    public static <T> Constructor<T> getRecordConstructor(Class<T> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        int length = fields.length;
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        if (constructors.length == 0) {
            return null;
        }
        List<Constructor> list = Arrays.stream(constructors).filter(i -> i.getParameterCount() == length).toList();
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            Constructor constructor = list.get(0);
            constructor.setAccessible(true);
            return constructor;
        }
        for (Constructor c : list) {
            boolean ok = true;
            for (Parameter p : c.getParameters()) {
                if (!Arrays.stream(fields).noneMatch(f -> f.getName().equals(p.getName()) && f.getType().equals(p.getType()))) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            c.setAccessible(true);
            return c;
        }
        return null;
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> clazz) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        int length = constructors.length;
        if (length == 0) {
            return null;
        }
        if (length > 1) {
            Arrays.sort(constructors, Comparator.comparing(Constructor::getParameterCount));
        }
        Constructor<?> constructor = constructors[0];
        constructor.setAccessible(true);
        return constructor;
    }

    public static <T> Constructor<T> getEntityConstructor(Class<T> clazz, boolean isRecord) {
        Constructor<T> constructor;
        Constructor<T> constructor2 = constructor = isRecord ? ReflectUtil.getRecordConstructor(clazz) : ReflectUtil.getDefaultConstructor(clazz);
        if (constructor == null) {
            throw new HcException("Class: " + clazz.getCanonicalName() + " can not found public constructor");
        }
        return constructor;
    }

    public static List<Field> getEntityFields(Class<?> clazz, boolean isRecord) {
        List<Field> fields = isRecord ? Arrays.asList(clazz.getDeclaredFields()) : ReflectUtil.getAllFieldsNotStaticOrTransient(clazz);
        fields.forEach(field -> field.setAccessible(true));
        return fields;
    }

    public static Function<Map<String, Object>, Object> getInstanceFunction(Constructor<?> constructor, List<Parameter> parameters, List<Field> fields, boolean isRecord) {
        return map -> {
            int parameterCount = parameters.size();
            Object[] values = new Object[parameterCount];
            for (int i = 0; i < parameterCount; ++i) {
                values[i] = map.get(((Parameter)parameters.get(i)).getName());
            }
            try {
                Object t = constructor.newInstance(values);
                if (!isRecord) {
                    for (Field field : fields) {
                        Object v = map.get(field.getName());
                        if (v == null) continue;
                        field.set(t, v);
                    }
                }
                return t;
            }
            catch (Exception e) {
                throw new HcException("failed to create an instance, errorMessage:" + e.getLocalizedMessage());
            }
        };
    }

    public static List<Field> getAllFields(Class<?> clazz, Predicate<Field> predicate) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            fields.addAll(ReflectUtil.getAllFields(superClass, predicate));
        }
        List<Field> list = Arrays.asList(clazz.getDeclaredFields());
        if (predicate != null) {
            fields.addAll(list.stream().filter(predicate).toList());
        } else {
            fields.addAll(list);
        }
        return fields;
    }

    public static List<Field> getAllFieldsNotStaticOrTransient(Class<?> clazz) {
        return ReflectUtil.getAllFields(clazz, field -> {
            int modifiers = field.getModifiers();
            return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers);
        });
    }

    public static <T> LambdaMethod getLambdaMethod(SerializableFunction<T, ?> lambda) {
        try {
            Method method = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(true);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke(lambda, new Object[0]);
            String className = serializedLambda.getImplClass().replaceAll("/", ".");
            return new LambdaMethod(Class.forName(className), serializedLambda.getImplMethodName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Field getFieldByMethodName(Class<?> clazz, String methodName) {
        try {
            if (clazz.isRecord()) {
                return clazz.getDeclaredField(methodName);
            }
            List<Field> fields = ReflectUtil.getAllFieldsNotStaticOrTransient(clazz);
            String getName = null;
            String isName = null;
            if (methodName.length() > 3 && methodName.startsWith("get")) {
                getName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            } else if (methodName.length() > 2 && methodName.startsWith("is")) {
                isName = methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
            }
            for (Field field : fields) {
                if (!field.getName().equals(getName) && !field.getName().equals(isName) && !field.getName().equals(methodName)) continue;
                return field;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }
}

