/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.huiche.exception.HcAssertException;
import org.jetbrains.annotations.Contract;

public class Assert {
    @Contract(value="_,false->fail", pure=true)
    public static void ok(String msg, boolean expression) {
        if (!expression) {
            throw new HcAssertException(msg);
        }
    }

    public static void ifTest(String msg, boolean preTest, Supplier<Boolean> expression) {
        Boolean r;
        if (preTest && ((r = expression.get()) == null || !r.booleanValue())) {
            throw new HcAssertException(msg);
        }
    }

    public static void ifNotEmpty(String msg, Supplier<Boolean> expression, Object ... args) {
        for (Object arg : args) {
            if (!Assert.checkEmpty(arg)) continue;
            return;
        }
        Boolean r = expression.get();
        if (r == null || !r.booleanValue()) {
            throw new HcAssertException(msg);
        }
    }

    public static <T> void equals(String msg, T a, T b) {
        if (!Assert.checkEquals(a, b)) {
            throw new HcAssertException(msg);
        }
    }

    public static void notEquals(String msg, Object a, Object b) {
        if (Assert.checkEquals(a, b)) {
            throw new HcAssertException(msg);
        }
    }

    @Contract(value="_,!null->fail", pure=true)
    public static void isEmpty(String msg, Object obj) {
        if (!Assert.checkEmpty(obj)) {
            throw new HcAssertException(msg);
        }
    }

    @Contract(value="_,!null,_->fail;_,_,!null->fail;", pure=true)
    public static void isEmpty(String msg, Object obj1, Object obj2) {
        Assert.isAllEmpty(msg, Arrays.asList(obj1, obj2));
    }

    @Contract(value="_,!null,_,_->fail;_,_,!null,_->fail;_,_,_,!null->fail;", pure=true)
    public static void isEmpty(String msg, Object obj1, Object obj2, Object obj3) {
        Assert.isAllEmpty(msg, Arrays.asList(obj1, obj2, obj3));
    }

    private static boolean checkEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return obj.toString().trim().isEmpty();
        }
        if (obj instanceof Iterable) {
            return !((Iterable)obj).iterator().hasNext();
        }
        if (obj instanceof Iterator) {
            return !((Iterator)obj).hasNext();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return ((Object[])obj).length == 0;
        }
        if (obj instanceof Enumeration) {
            return !((Enumeration)obj).hasMoreElements();
        }
        return false;
    }

    private static boolean checkEquals(Object a, Object b) {
        boolean r = Objects.equals(a, b);
        if (!r && a instanceof Number && b instanceof Number) {
            r = ((Number)a).doubleValue() - ((Number)b).doubleValue() == 0.0;
        }
        return r;
    }

    @Contract(value="_,null->fail", pure=true)
    public static void notEmpty(String msg, Object obj) {
        if (Assert.checkEmpty(obj)) {
            throw new HcAssertException(msg);
        }
    }

    @Contract(value="_,null,_->fail;_,_,null->fail", pure=true)
    public static void notEmpty(String msg, Object obj1, Object obj2) {
        Assert.notAnyEmpty(msg, Arrays.asList(obj1, obj2));
    }

    @Contract(value="_,null,_,_->fail;_,_,null,_->fail;_,_,_,null->fail", pure=true)
    public static void notEmpty(String msg, Object obj1, Object obj2, Object obj3) {
        Assert.notAnyEmpty(msg, Arrays.asList(obj1, obj2, obj3));
    }

    @Contract(value="_,null,_,_,_->fail;_,_,null,_,_->fail;_,_,_,null,_->fail;_,_,_,_,null->fail", pure=true)
    public static void notEmpty(String msg, Object obj1, Object obj2, Object obj3, Object obj4) {
        Assert.notAnyEmpty(msg, Arrays.asList(obj1, obj2, obj3, obj4));
    }

    @Contract(value="_,null,_,_,_,_->fail;_,_,null,_,_,_->fail;_,_,_,null,_,_->fail;_,_,_,_,null,_->fail;_,_,_,_,_,null->fail", pure=true)
    public static void notEmpty(String msg, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5) {
        Assert.notAnyEmpty(msg, Arrays.asList(obj1, obj2, obj3, obj4, obj5));
    }

    public static <T> void notEmpty(String msg, T preObj, Function<T, Collection<Object>> checks) {
        if (Assert.checkEmpty(preObj)) {
            throw new HcAssertException(msg);
        }
        Collection<Object> list = checks.apply(preObj);
        if (Assert.checkEmpty(list)) {
            throw new HcAssertException(msg);
        }
        Assert.notAnyEmpty(msg, list);
    }

    public static void isAllEmpty(String msg, Collection<Object> args) {
        for (Object arg : args) {
            if (Assert.checkEmpty(arg)) continue;
            throw new HcAssertException(msg);
        }
    }

    public static void notAllEmpty(String msg, Collection<Object> args) {
        boolean r = true;
        for (Object arg : args) {
            if (Assert.checkEmpty(arg)) continue;
            r = false;
        }
        if (r) {
            throw new HcAssertException(msg);
        }
    }

    public static void notAnyEmpty(String msg, Collection<Object> args) {
        for (Object arg : args) {
            if (!Assert.checkEmpty(arg)) continue;
            throw new HcAssertException(msg);
        }
    }

    public static <T> void isIn(String msg, T src, List<T> target) {
        if (src != null) {
            for (T t : target) {
                if (!Assert.checkEquals(src, t)) continue;
                return;
            }
        }
        throw new HcAssertException(msg);
    }

    public static <T> void notIn(String msg, T src, List<T> target) {
        boolean r;
        boolean bl = r = src != null;
        if (r) {
            for (T t : target) {
                if (!Assert.checkEquals(src, t)) continue;
                r = false;
            }
        }
        if (!r) {
            throw new HcAssertException(msg);
        }
    }
}

