package org.huiche.support;

import java.beans.Introspector;

/**
 * @author Maning
 */
public class NamingUtil {
    public static String camel2snake(String camelCase) {
        int length = camelCase.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; i++) {
            char ch = camelCase.charAt(i);
            if (i > 0 && Character.isUpperCase(ch) && Character.isLowerCase(camelCase.charAt(i - 1))) {
                sb.append("_");
            }
            sb.append(Character.toLowerCase(ch));
        }
        return sb.toString();
    }

    public static String pascal2camel(String pascalCase) {
        return Introspector.decapitalize(pascalCase);
    }
}
