/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.apt;

import com.querydsl.core.types.PathMetadataFactory;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.DatePath;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.TimePath;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.PrimaryKey;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.types.EnumByNameType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.huiche.annotation.Column;
import org.huiche.annotation.Table;
import org.huiche.dao.support.EnumTypePool;
import org.huiche.support.NamingUtil;
import org.huiche.support.TypeMapping;

public class QuerydslMapperGenerator {
    private final Elements elementUtils;
    private final Messager messager;
    private final Types types;

    public QuerydslMapperGenerator(Elements elementUtils, Messager messager, Types types) {
        this.elementUtils = elementUtils;
        this.messager = messager;
        this.types = types;
    }

    public TypeSpec createMapper(TypeElement entity, String packageName) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, "create mapper for:" + entity.getQualifiedName());
        String entityName = entity.getSimpleName().toString();
        ClassName entityClass = ClassName.get((TypeElement)entity);
        Table table = entity.getAnnotation(Table.class);
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        ArrayList<String> pks = new ArrayList<String>();
        ArrayList<CodeBlock> metaList = new ArrayList<CodeBlock>();
        ArrayList<CodeBlock> enumList = new ArrayList<CodeBlock>();
        int index = 1;
        for (VariableElement field : this.scanFields(entity)) {
            Set<Modifier> mods = field.getModifiers();
            if (mods.contains((Object)Modifier.STATIC) || mods.contains((Object)Modifier.TRANSIENT)) continue;
            Column column = field.getAnnotation(Column.class);
            if (column != null && !org.huiche.support.PrimaryKey.NOT_PK.equals((Object)column.primaryKey())) {
                pks.add(field.getSimpleName().toString());
            }
            fields.add(this.createField(field, column, index++, metaList, enumList));
        }
        ClassName mapperClass = ClassName.get((String)packageName, (String)("Q" + entityName), (String[])new String[0]);
        String mapperVar = NamingUtil.pascal2camel((String)entityName);
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)mapperClass).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("generated by huiche-apt", new Object[0]).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(RelationalPathBase.class), (TypeName[])new TypeName[]{entityClass})).addField(FieldSpec.builder((TypeName)mapperClass, (String)NamingUtil.camel2snake((String)entityName).toUpperCase(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T($S)", new Object[]{mapperClass, NamingUtil.camel2snake((String)mapperVar)}).build()).addFields(fields);
        if (!pks.isEmpty()) {
            builder.addField(this.createPrimaryKey(entityClass, pks));
        }
        builder.addMethod(this.createConstructor(entityClass, table));
        builder.addMethod(this.createMetaMethod(metaList));
        if (!enumList.isEmpty()) {
            CodeBlock.Builder staticBuilder = CodeBlock.builder();
            for (CodeBlock code : enumList) {
                staticBuilder.addStatement(code);
            }
            builder.addStaticBlock(staticBuilder.build());
        }
        return builder.build();
    }

    private List<VariableElement> scanFields(TypeElement entity) {
        Element fatherEle;
        ArrayList<VariableElement> list = new ArrayList<VariableElement>();
        TypeMirror father = entity.getSuperclass();
        if (father != null && !Object.class.getCanonicalName().equals(this.getCanonicalName(father)) && (fatherEle = this.types.asElement(father)) != null && fatherEle.getKind() == ElementKind.CLASS) {
            list.addAll(this.scanFields((TypeElement)this.types.asElement(father)));
        }
        list.addAll(ElementFilter.fieldsIn(this.elementUtils.getAllMembers(entity)));
        return list;
    }

    private MethodSpec createConstructor(ClassName clazz, Table table) {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "variable", new Modifier[0]).addStatement("super($T.class, $T.forVariable(variable), $S, $S)", new Object[]{clazz, PathMetadataFactory.class, "".equals(table.schema()) ? "null" : table.schema(), "".equals(table.name()) ? NamingUtil.camel2snake((String)clazz.simpleName()) : table.name()}).addStatement("addMetadata()", new Object[0]).build();
    }

    private MethodSpec createMetaMethod(List<CodeBlock> metaList) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"addMetadata").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.VOID);
        metaList.forEach(arg_0 -> ((MethodSpec.Builder)builder).addStatement(arg_0));
        return builder.build();
    }

    private FieldSpec createField(VariableElement element, Column column, int index, List<CodeBlock> metaList, List<CodeBlock> enumList) {
        Element enumEle;
        TypeMirror type = element.asType();
        String typeClassName = this.getCanonicalName(type);
        boolean isEnum = false;
        String javaName = element.getSimpleName().toString();
        String columnName = NamingUtil.camel2snake((String)javaName);
        JDBCType jdbcType = TypeMapping.parseJdbcType((String)typeClassName);
        boolean isPk = false;
        boolean nullable = true;
        Integer length = null;
        Integer precision = null;
        if (column != null) {
            columnName = "".equals(column.name()) ? columnName : column.name();
            jdbcType = JDBCType.NULL.equals(column.jdbcType()) ? jdbcType : column.jdbcType();
            isPk = !org.huiche.support.PrimaryKey.NOT_PK.equals((Object)column.primaryKey());
            nullable = column.nullable();
            length = column.length() >= 0 ? Integer.valueOf(column.length()) : null;
            Integer n = precision = column.precision() >= 0 ? Integer.valueOf(column.precision()) : null;
        }
        if (jdbcType == null) {
            jdbcType = TypeMapping.parseJdbcType((String)typeClassName);
        }
        if (jdbcType == null && type.getKind() == TypeKind.DECLARED && (enumEle = this.types.asElement(type)).getKind() == ElementKind.ENUM) {
            jdbcType = TypeMapping.parseJdbcType((String)Enum.class.getCanonicalName());
            isEnum = true;
        }
        if (jdbcType == null) {
            throw new RuntimeException("can not support jdbcType in:" + javaName);
        }
        TypeName typeName = TypeName.get((TypeMirror)type);
        FieldSpec spec = null;
        if (Objects.equals(Boolean.class.getCanonicalName(), typeClassName)) {
            spec = FieldSpec.builder(BooleanPath.class, (String)javaName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createBoolean($S)", new Object[]{javaName}).build();
        } else if (Objects.equals(Byte.class.getCanonicalName(), typeClassName) || Objects.equals(Short.class.getCanonicalName(), typeClassName) || Objects.equals(Integer.class.getCanonicalName(), typeClassName) || Objects.equals(Long.class.getCanonicalName(), typeClassName) || Objects.equals(Float.class.getCanonicalName(), typeClassName) || Objects.equals(Double.class.getCanonicalName(), typeClassName) || Objects.equals(BigInteger.class.getCanonicalName(), typeClassName) || Objects.equals(BigDecimal.class.getCanonicalName(), typeClassName)) {
            spec = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(NumberPath.class), (TypeName[])new TypeName[]{typeName}), (String)javaName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createNumber($S, $T.class)", new Object[]{javaName, typeName}).build();
        } else if (Objects.equals(String.class.getCanonicalName(), typeClassName)) {
            if (Objects.equals(String.class.getCanonicalName(), typeClassName) && length == null) {
                length = 255;
            }
            spec = FieldSpec.builder(StringPath.class, (String)javaName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createString($S)", new Object[]{javaName}).build();
        } else if (Objects.equals(Character.class.getCanonicalName(), typeClassName)) {
            length = 1;
            spec = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SimplePath.class), (TypeName[])new TypeName[]{typeName}), (String)javaName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createSimple($S, $T.class)", new Object[]{javaName, typeName}).build();
        } else if (Objects.equals(LocalTime.class.getCanonicalName(), typeClassName) || Objects.equals(OffsetTime.class.getCanonicalName(), typeClassName)) {
            spec = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TimePath.class), (TypeName[])new TypeName[]{typeName}), (String)javaName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createTime($S, $T.class)", new Object[]{javaName, typeName}).build();
        } else if (Objects.equals(LocalDate.class.getCanonicalName(), typeClassName)) {
            spec = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(DatePath.class), (TypeName[])new TypeName[]{typeName}), (String)javaName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createDate($S, $T.class)", new Object[]{javaName, typeName}).build();
        } else if (Objects.equals(Date.class.getCanonicalName(), typeClassName) || Objects.equals(LocalDateTime.class.getCanonicalName(), typeClassName) || Objects.equals(OffsetDateTime.class.getCanonicalName(), typeClassName) || Objects.equals(ZonedDateTime.class.getCanonicalName(), typeClassName)) {
            spec = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(DateTimePath.class), (TypeName[])new TypeName[]{typeName}), (String)javaName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createDateTime($S, $T.class)", new Object[]{javaName, typeName}).build();
        } else if (Objects.equals(byte[].class.getCanonicalName(), typeClassName)) {
            spec = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SimplePath.class), (TypeName[])new TypeName[]{typeName}), (String)javaName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createSimple($S, $T.class)", new Object[]{javaName, typeName}).build();
        } else if (isEnum) {
            spec = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(EnumPath.class), (TypeName[])new TypeName[]{typeName}), (String)javaName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createEnum($S, $T.class)", new Object[]{javaName, typeName}).build();
            enumList.add(CodeBlock.of((String)"$T.put($T.class, new $T<>($T.class))", (Object[])new Object[]{EnumTypePool.class, type, EnumByNameType.class, type}));
        }
        if (spec == null) {
            throw new RuntimeException("can not support spec in:" + javaName);
        }
        String format = "addMetadata($L, $T.named($S).withIndex($L).ofType($T.$L)";
        if (isPk || !nullable) {
            format = format + ".notNull()";
        }
        if (length != null) {
            format = format + ".withSize(" + length + ")";
            if (precision != null) {
                format = format + ".withDigits(" + precision + ")";
            }
        }
        format = format + ")";
        metaList.add(CodeBlock.of((String)format, (Object[])new Object[]{javaName, ColumnMetadata.class, columnName, index, java.sql.Types.class, jdbcType.getName()}));
        return spec;
    }

    private FieldSpec createPrimaryKey(ClassName entityClass, List<String> pks) {
        return FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(PrimaryKey.class), (TypeName[])new TypeName[]{entityClass}), (String)"primary", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("createPrimaryKey(" + String.join((CharSequence)", ", pks) + ")", new Object[0]).build();
    }

    private String getCanonicalName(TypeMirror typeMirror) {
        return TypeName.get((TypeMirror)typeMirror).toString();
    }
}

