/*
 * Decompiled with CFR 0.152.
 */
package org.htuple;

import org.apache.hadoop.conf.Configuration;
import org.htuple.ShuffleUtils;
import org.htuple.Tuple;

public class TuplePartitioner {
    private final Configuration conf;
    private final int[] indices;

    public TuplePartitioner(Configuration conf) {
        this.conf = conf;
        this.indices = ShuffleUtils.indexesFromConfig(conf, "org.htuple.partitioner.indexes");
    }

    public Configuration getConf() {
        return this.conf;
    }

    public int getPartition(Tuple key, int numPartitions) {
        int result = 1;
        int indexOffset = 0;
        for (int i = 0; i < key.size(); ++i) {
            if (i != this.indices[indexOffset]) continue;
            Object element = key.getObject(i);
            result = 31 * result + (element == null ? 0 : element.hashCode());
            if (++indexOffset == this.indices.length) break;
        }
        return (result * 127 & Integer.MAX_VALUE) % numPartitions;
    }
}

