/*
 * Decompiled with CFR 0.152.
 */
package org.htuple;

import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.htuple.ShuffleUtils;
import org.htuple.Tuple;

public abstract class TupleComparator
extends WritableComparator
implements Configurable {
    private Configuration conf;
    private int[] indices;

    public TupleComparator() {
        super(Tuple.class, true);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.indices = ShuffleUtils.indexesFromConfig(conf, this.getIndexConfigName());
    }

    public abstract String getIndexConfigName();

    public Configuration getConf() {
        return this.conf;
    }

    public int compare(WritableComparable o1, WritableComparable o2) {
        Tuple lhs = (Tuple)o1;
        Tuple rhs = (Tuple)o2;
        for (int idx : this.indices) {
            int cmp;
            Object lhsObject = lhs.getObject(idx);
            Object rhsObject = rhs.getObject(idx);
            if (lhsObject == null && rhsObject == null) continue;
            int n = lhsObject == null ? -1 : (cmp = rhsObject == null ? 1 : 0);
            if (cmp != 0) {
                return cmp;
            }
            cmp = ((Comparable)lhsObject).compareTo(rhsObject);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

