/*
 * Decompiled with CFR 0.152.
 */
package com.htuple;

import org.apache.hadoop.conf.Configuration;
import org.htuple.ShuffleUtils;
import org.htuple.Tuple;
import org.htuple.TuplePartitioner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TuplePartitionerTest {
    Configuration conf;

    @Before
    public void setup() {
        this.conf = new Configuration();
    }

    @Test(expected=IllegalStateException.class)
    public void testNoConfigSet() {
        new TuplePartitioner(new Configuration());
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyConfig() {
        this.conf.setStrings("org.htuple.partitioner.indexes", new String[]{""});
        new TuplePartitioner(this.conf);
    }

    @Test
    public void testDifferentPartitions() {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        t1.add("alex").add(Integer.valueOf(1)).add(Integer.valueOf(3));
        t2.add("alex").add(Integer.valueOf(2)).add(Integer.valueOf(2));
        ShuffleUtils.configBuilder().setPartitionerIndices(new int[]{0}).configure(this.conf);
        TuplePartitioner partitioner = new TuplePartitioner(this.conf);
        Assert.assertEquals((long)partitioner.getPartition(t1, 10), (long)partitioner.getPartition(t2, 10));
        ShuffleUtils.configBuilder().setPartitionerIndices(new int[]{1}).configure(this.conf);
        partitioner = new TuplePartitioner(this.conf);
        Assert.assertNotSame((Object)partitioner.getPartition(t1, 10), (Object)partitioner.getPartition(t2, 10));
        ShuffleUtils.configBuilder().setPartitionerIndices(new int[]{2}).configure(this.conf);
        partitioner = new TuplePartitioner(this.conf);
        Assert.assertNotSame((Object)partitioner.getPartition(t1, 10), (Object)partitioner.getPartition(t2, 10));
        ShuffleUtils.configBuilder().setPartitionerIndices(new int[]{0, 1}).configure(this.conf);
        partitioner = new TuplePartitioner(this.conf);
        Assert.assertNotSame((Object)partitioner.getPartition(t1, 10), (Object)partitioner.getPartition(t2, 10));
        ShuffleUtils.configBuilder().setPartitionerIndices(new int[]{0, 2}).configure(this.conf);
        partitioner = new TuplePartitioner(this.conf);
        Assert.assertNotSame((Object)partitioner.getPartition(t1, 10), (Object)partitioner.getPartition(t2, 10));
    }

    @Test
    public void testIndexOutOfBounds() {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        t1.add("alex").add(Integer.valueOf(1)).add(Integer.valueOf(3));
        t2.add("alex").add(Integer.valueOf(2)).add(Integer.valueOf(2));
        ShuffleUtils.configBuilder().setPartitionerIndices(new int[]{0, 5}).configure(this.conf);
        TuplePartitioner partitioner = new TuplePartitioner(this.conf);
        Assert.assertEquals((long)partitioner.getPartition(t1, 10), (long)partitioner.getPartition(t2, 10));
    }
}

