/*
 * Decompiled with CFR 0.152.
 */
package org.htuple;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.htuple.SerializationUtils;

public class Tuple
implements WritableComparable<Tuple> {
    private List<Object> fields = new ArrayList<Object>();

    public Tuple clear() {
        this.fields.clear();
        return this;
    }

    public int size() {
        return this.fields.size();
    }

    public Tuple set(int idx, Object val) {
        while (idx >= this.fields.size()) {
            this.fields.add(null);
        }
        this.fields.set(idx, val);
        return this;
    }

    public Tuple set(Enum<?> eval, Object val) {
        this.set(eval.ordinal(), val);
        return this;
    }

    public Tuple set(Enum<?> eval, Short val) {
        this.set(eval, (Object)val);
        return this;
    }

    public Tuple setShort(Enum<?> eval, Short val) {
        this.set(eval, (Object)val);
        return this;
    }

    public Tuple set(int idx, Short val) {
        this.set(idx, (Object)val);
        return this;
    }

    public Tuple setShort(int idx, Short val) {
        this.set(idx, (Object)val);
        return this;
    }

    public Tuple set(Enum<?> eval, Integer val) {
        this.set(eval, (Object)val);
        return this;
    }

    public Tuple setInt(Enum<?> eval, Integer val) {
        this.set(eval, (Object)val);
        return this;
    }

    public Tuple set(int idx, Integer val) {
        this.set(idx, (Object)val);
        return this;
    }

    public Tuple setInt(int idx, Integer val) {
        this.set(idx, (Object)val);
        return this;
    }

    public Tuple set(Enum<?> eval, Long val) {
        this.set(eval, (Object)val);
        return this;
    }

    public Tuple setLong(Enum<?> eval, Long val) {
        this.set(eval, (Object)val);
        return this;
    }

    public Tuple setLong(int idx, Integer val) {
        this.set(idx, (Object)val);
        return this;
    }

    public Tuple set(int idx, String val) {
        this.set(idx, (Object)val);
        return this;
    }

    public Tuple setString(int idx, String val) {
        this.set(idx, (Object)val);
        return this;
    }

    public Tuple set(Enum<?> eval, String val) {
        this.set(eval, (Object)val);
        return this;
    }

    public Tuple setString(Enum<?> eval, String val) {
        this.set(eval, (Object)val);
        return this;
    }

    public Tuple set(int idx, Boolean val) {
        this.set(idx, (Object)val);
        return this;
    }

    public Tuple setBoolean(int idx, Boolean val) {
        this.set(idx, (Object)val);
        return this;
    }

    public Tuple set(Enum<?> eval, Double val) {
        this.set(eval, (Object)val);
        return this;
    }

    public Tuple setDouble(Enum<?> eval, Double val) {
        this.set(eval, (Object)val);
        return this;
    }

    public Tuple set(int idx, Double val) {
        this.set(idx, (Object)val);
        return this;
    }

    public Tuple setDouble(int idx, Double val) {
        this.set(idx, (Object)val);
        return this;
    }

    public Tuple set(Enum<?> eval, Float val) {
        this.set(eval, (Object)val);
        return this;
    }

    public Tuple set(int idx, Float val) {
        this.set(idx, (Object)val);
        return this;
    }

    public Tuple setFloat(Enum<?> eval, Float val) {
        this.set(eval, (Object)val);
        return this;
    }

    public Tuple setFloat(int idx, Float val) {
        this.set(idx, (Object)val);
        return this;
    }

    public Tuple set(Enum<?> eval, BytesWritable val) {
        this.set(eval, (Object)val);
        return this;
    }

    public Tuple set(int idx, BytesWritable val) {
        this.set(idx, (Object)val);
        return this;
    }

    public Tuple setBytes(Enum<?> eval, BytesWritable val) {
        this.set(eval, (Object)val);
        return this;
    }

    public Tuple setBytes(int idx, BytesWritable val) {
        this.set(idx, (Object)val);
        return this;
    }

    public Tuple add(Short val) {
        this.fields.add(val);
        return this;
    }

    public Tuple addShort(Short val) {
        this.fields.add(val);
        return this;
    }

    public Tuple add(Integer val) {
        this.fields.add(val);
        return this;
    }

    public Tuple addInt(Integer val) {
        this.fields.add(val);
        return this;
    }

    public Tuple add(Long val) {
        this.fields.add(val);
        return this;
    }

    public Tuple addLong(Long val) {
        this.fields.add(val);
        return this;
    }

    public Tuple add(String val) {
        this.fields.add(val);
        return this;
    }

    public Tuple addString(String val) {
        this.fields.add(val);
        return this;
    }

    public Tuple add(Boolean val) {
        this.fields.add(val);
        return this;
    }

    public Tuple addBoolean(Boolean val) {
        this.fields.add(val);
        return this;
    }

    public Tuple add(Double val) {
        this.fields.add(val);
        return this;
    }

    public Tuple addDouble(Double val) {
        this.fields.add(val);
        return this;
    }

    public Tuple add(Float val) {
        this.fields.add(val);
        return this;
    }

    public Tuple addFloat(Float val) {
        this.fields.add(val);
        return this;
    }

    public Tuple add(BytesWritable val) {
        this.fields.add(val);
        return this;
    }

    public Tuple addBytes(BytesWritable val) {
        this.fields.add(val);
        return this;
    }

    public Object getObject(int idx) {
        if (idx < 0) {
            throw new IllegalArgumentException("Negative size: " + idx);
        }
        if (idx >= this.fields.size()) {
            return null;
        }
        return this.fields.get(idx);
    }

    public Object getObject(Enum<?> eval) {
        return this.getObject(eval.ordinal());
    }

    public Short getShort(Enum<?> eval) {
        return (Short)this.getObject(eval);
    }

    public Short getShort(int idx) {
        return (Short)this.getObject(idx);
    }

    public Integer getInt(Enum<?> eval) {
        return (Integer)this.getObject(eval);
    }

    public Integer getInt(int idx) {
        return (Integer)this.getObject(idx);
    }

    public Long getLong(Enum<?> eval) {
        return (Long)this.getObject(eval);
    }

    public Long getLong(int idx) {
        return (Long)this.getObject(idx);
    }

    public String getString(Enum<?> eval) {
        return (String)this.getObject(eval);
    }

    public String getString(int idx) {
        return (String)this.getObject(idx);
    }

    public Boolean getBoolean(Enum<?> eval) {
        return (Boolean)this.getObject(eval);
    }

    public Boolean getBoolean(int idx) {
        return (Boolean)this.getObject(idx);
    }

    public Double getDouble(Enum<?> eval) {
        return (Double)this.getObject(eval);
    }

    public Double getDouble(int idx) {
        return (Double)this.getObject(idx);
    }

    public Float getFloat(Enum<?> eval) {
        return (Float)this.getObject(eval);
    }

    public Float getFloat(int idx) {
        return (Float)this.getObject(idx);
    }

    public BytesWritable getBytes(Enum<?> eval) {
        return (BytesWritable)this.getObject(eval);
    }

    public BytesWritable getBytes(int idx) {
        return (BytesWritable)this.getObject(idx);
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.fields.size());
        for (Object element : this.fields) {
            SerializationUtils.write(out, element);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.fields.clear();
        int elementCount = WritableUtils.readVInt((DataInput)in);
        while (elementCount-- > 0) {
            this.fields.add(SerializationUtils.read(in));
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.fields.toArray());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Tuple)) {
            return false;
        }
        Tuple other = (Tuple)object;
        if (this.fields.size() != other.fields.size()) {
            return false;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            Object lhs = this.fields.get(i);
            Object rhs = other.fields.get(i);
            if (lhs == null && rhs == null) continue;
            if (lhs == null || rhs == null) {
                return false;
            }
            if (lhs.equals(rhs)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.fields.size(); ++i) {
            sb.append("[").append(i).append("]='").append(this.fields.get(i)).append(", ");
        }
        return sb.toString();
    }

    public int compareTo(Tuple other) {
        for (int i = 0; i < this.fields.size() && i < other.fields.size(); ++i) {
            int cmp;
            Object lhs = this.fields.get(i);
            Object rhs = other.fields.get(i);
            if (lhs == null && rhs == null) continue;
            int n = lhs == null ? -1 : (cmp = rhs == null ? 1 : 0);
            if (cmp != 0) {
                return cmp;
            }
            cmp = ((Comparable)lhs).compareTo(rhs);
            if (cmp == 0) continue;
            return cmp;
        }
        return this.fields.size() - other.fields.size();
    }
}

