/*
 * Decompiled with CFR 0.152.
 */
package org.htuple;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapreduce.Partitioner;
import org.htuple.TupleGroupingComparator;
import org.htuple.TupleMapRedPartitioner;
import org.htuple.TupleMapReducePartitioner;
import org.htuple.TupleSortComparator;

public class ShuffleUtils {
    public static final String BASE_CONFIG_NAME = "org.htuple";
    public static final String PARTITIONER_INDEXES_CONFIG_NAME = "org.htuple.partitioner.indexes";
    public static final String SORTING_INDEXES_CONFIG_NAME = "org.htuple.sorting.indexes";
    public static final String GROUPING_INDEXES_CONFIG_NAME = "org.htuple.grouping.indexes";

    public static ConfigBuilder configBuilder() {
        return new ConfigBuilder();
    }

    public static int[] indexesFromConfig(Configuration conf, String confName) {
        String[] parts = conf.getStrings(confName);
        if (parts == null || parts.length == 0) {
            throw new IllegalStateException(String.format("Empty or no configuration set for '%s'", confName));
        }
        int[] indices = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            indices[i] = Integer.valueOf(parts[i]);
        }
        return indices;
    }

    public static String[] indexesToStrings(int[] indexes) {
        if (indexes == null || indexes.length == 0) {
            throw new IllegalStateException("Empty or null indexes");
        }
        String[] parts = new String[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            parts[i] = String.valueOf(indexes[i]);
        }
        return parts;
    }

    public static class ConfigBuilder {
        int[] partitionerIndices;
        int[] sortIndices;
        int[] groupIndices;
        boolean useNewApi;

        public ConfigBuilder useOldApi() {
            this.useNewApi = false;
            return this;
        }

        public ConfigBuilder useNewApi() {
            this.useNewApi = true;
            return this;
        }

        public ConfigBuilder setPartitionerIndices(int ... indices) {
            this.partitionerIndices = indices;
            return this;
        }

        public ConfigBuilder setPartitionerIndices(Enum<?> ... indices) {
            this.partitionerIndices = ConfigBuilder.enumOrdinalsToArray(indices);
            return this;
        }

        public ConfigBuilder setSortIndices(int ... indices) {
            this.sortIndices = indices;
            return this;
        }

        public ConfigBuilder setSortIndices(Enum<?> ... indices) {
            this.sortIndices = ConfigBuilder.enumOrdinalsToArray(indices);
            return this;
        }

        public ConfigBuilder setGroupIndices(int ... indices) {
            this.groupIndices = indices;
            return this;
        }

        public ConfigBuilder setGroupIndices(Enum<?> ... indices) {
            this.groupIndices = ConfigBuilder.enumOrdinalsToArray(indices);
            return this;
        }

        public void configure(Configuration conf) {
            if (this.useNewApi) {
                this.configureIndexes(conf, this.partitionerIndices, ShuffleUtils.PARTITIONER_INDEXES_CONFIG_NAME, "mapreduce.partitioner.class", TupleMapReducePartitioner.class, Partitioner.class);
            } else {
                this.configureIndexes(conf, this.partitionerIndices, ShuffleUtils.PARTITIONER_INDEXES_CONFIG_NAME, "mapred.partitioner.class", TupleMapRedPartitioner.class, org.apache.hadoop.mapred.Partitioner.class);
            }
            this.configureIndexes(conf, this.sortIndices, ShuffleUtils.SORTING_INDEXES_CONFIG_NAME, "mapred.output.key.comparator.class", TupleSortComparator.class, RawComparator.class);
            this.configureIndexes(conf, this.groupIndices, ShuffleUtils.GROUPING_INDEXES_CONFIG_NAME, "mapred.output.value.groupfn.class", TupleGroupingComparator.class, RawComparator.class);
        }

        private void configureIndexes(Configuration conf, int[] indexes, String configName, String name, Class<?> theClass, Class<?> xface) {
            if (indexes != null) {
                conf.setStrings(configName, ShuffleUtils.indexesToStrings(indexes));
                conf.setClass(name, theClass, xface);
            }
        }

        public static int[] enumOrdinalsToArray(Enum<?> ... enums) {
            int[] array = new int[enums.length];
            for (int i = 0; i < enums.length; ++i) {
                array[i] = enums[i].ordinal();
            }
            return array;
        }
    }
}

