/*
 * Decompiled with CFR 0.152.
 */
package org.htuple;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.WritableUtils;

public class SerializationUtils {
    public static final int NULL_ELEMENT_TYPE = 9;
    private static final Map<Class, TupleElementSerializer> staticTupleElementWriters = new IdentityHashMap<Class, TupleElementSerializer>();
    private static final Map<Integer, TupleElementSerializer> staticElementIdWriters = new HashMap<Integer, TupleElementSerializer>();

    private static void populateSerializationDetails(Class clazz, TupleElementSerializer serializer) {
        staticTupleElementWriters.put(clazz, serializer);
        staticElementIdWriters.put(serializer.getElementTypeId(), serializer);
    }

    public static void write(DataOutput stream, Object element) throws IOException {
        Class elementClass = element == null ? NullWritable.class : element.getClass();
        TupleElementSerializer serializer = staticTupleElementWriters.get(elementClass);
        if (serializer == null) {
            throw new IllegalArgumentException("Unsupported type: " + elementClass.getName());
        }
        serializer.write(stream, element);
    }

    public static Object read(DataInput stream) throws IOException {
        int type = WritableUtils.readVInt((DataInput)stream);
        TupleElementSerializer serializer = staticElementIdWriters.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
        return serializer.read(stream);
    }

    static {
        SerializationUtils.populateSerializationDetails(String.class, new TupleElementSerializer(){

            @Override
            public void write(DataOutput stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)this.getElementTypeId());
                WritableUtils.writeString((DataOutput)stream, (String)((String)element));
            }

            @Override
            public Object read(DataInput stream) throws IOException {
                return WritableUtils.readString((DataInput)stream);
            }

            @Override
            public int getElementTypeId() {
                return 1;
            }
        });
        SerializationUtils.populateSerializationDetails(Float.class, new TupleElementSerializer(){

            @Override
            public void write(DataOutput stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)this.getElementTypeId());
                stream.writeFloat(((Float)element).floatValue());
            }

            @Override
            public Object read(DataInput stream) throws IOException {
                return Float.valueOf(stream.readFloat());
            }

            @Override
            public int getElementTypeId() {
                return 2;
            }
        });
        SerializationUtils.populateSerializationDetails(Double.class, new TupleElementSerializer(){

            @Override
            public void write(DataOutput stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)this.getElementTypeId());
                stream.writeDouble((Double)element);
            }

            @Override
            public Object read(DataInput stream) throws IOException {
                return stream.readDouble();
            }

            @Override
            public int getElementTypeId() {
                return 3;
            }
        });
        SerializationUtils.populateSerializationDetails(Integer.class, new TupleElementSerializer(){

            @Override
            public void write(DataOutput stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)this.getElementTypeId());
                WritableUtils.writeVInt((DataOutput)stream, (int)((Integer)element));
            }

            @Override
            public Object read(DataInput stream) throws IOException {
                return WritableUtils.readVInt((DataInput)stream);
            }

            @Override
            public int getElementTypeId() {
                return 4;
            }
        });
        SerializationUtils.populateSerializationDetails(Long.class, new TupleElementSerializer(){

            @Override
            public void write(DataOutput stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)this.getElementTypeId());
                WritableUtils.writeVLong((DataOutput)stream, (long)((Long)element));
            }

            @Override
            public Object read(DataInput stream) throws IOException {
                return WritableUtils.readVLong((DataInput)stream);
            }

            @Override
            public int getElementTypeId() {
                return 5;
            }
        });
        SerializationUtils.populateSerializationDetails(Boolean.class, new TupleElementSerializer(){

            @Override
            public void write(DataOutput stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)this.getElementTypeId());
                stream.writeBoolean((Boolean)element);
            }

            @Override
            public Object read(DataInput stream) throws IOException {
                return stream.readBoolean();
            }

            @Override
            public int getElementTypeId() {
                return 6;
            }
        });
        SerializationUtils.populateSerializationDetails(Short.class, new TupleElementSerializer(){

            @Override
            public void write(DataOutput stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)this.getElementTypeId());
                stream.writeShort(((Short)element).shortValue());
            }

            @Override
            public Object read(DataInput stream) throws IOException {
                return stream.readShort();
            }

            @Override
            public int getElementTypeId() {
                return 7;
            }
        });
        SerializationUtils.populateSerializationDetails(BytesWritable.class, new TupleElementSerializer(){

            @Override
            public void write(DataOutput stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)this.getElementTypeId());
                ((BytesWritable)element).write(stream);
            }

            @Override
            public Object read(DataInput stream) throws IOException {
                BytesWritable writable = new BytesWritable();
                writable.readFields(stream);
                return writable;
            }

            @Override
            public int getElementTypeId() {
                return 8;
            }
        });
        SerializationUtils.populateSerializationDetails(NullWritable.class, new TupleElementSerializer(){

            @Override
            public void write(DataOutput stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)this.getElementTypeId());
            }

            @Override
            public Object read(DataInput stream) throws IOException {
                return null;
            }

            @Override
            public int getElementTypeId() {
                return 9;
            }
        });
    }

    protected static interface TupleElementSerializer {
        public void write(DataOutput var1, Object var2) throws IOException;

        public Object read(DataInput var1) throws IOException;

        public int getElementTypeId();
    }
}

