/*
 * Decompiled with CFR 0.152.
 */
package com.htuple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import org.apache.hadoop.io.BytesWritable;
import org.htuple.Tuple;
import org.junit.Assert;
import org.junit.Test;

public class TupleTest {
    @Test
    public void testEmptyEqualsAndHash() throws Exception {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        Assert.assertEquals((Object)t1, (Object)t2);
        Assert.assertEquals((long)t1.hashCode(), (long)t2.hashCode());
    }

    @Test
    public void testFlippedEqualsAndHash() throws Exception {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        t1.add(Integer.valueOf(2)).add(Integer.valueOf(1));
        t2.add(Integer.valueOf(1)).add(Integer.valueOf(2));
        Assert.assertNotSame((Object)t1, (Object)t2);
        Assert.assertNotSame((Object)t1.hashCode(), (Object)t2.hashCode());
    }

    @Test
    public void testMultiElementEqualsAndHash() throws Exception {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        t1.add("bob").add(Integer.valueOf(1)).add(Long.valueOf(2L)).add(Short.valueOf((short)3)).add(Boolean.valueOf(true)).add((String)null).add(Double.valueOf(12.3)).add(Float.valueOf(21.2f)).add(new BytesWritable(new byte[]{1, 2, 3}));
        t2.add("bob").add(Integer.valueOf(1)).add(Long.valueOf(2L)).add(Short.valueOf((short)3)).add(Boolean.valueOf(true)).add((String)null).add(Double.valueOf(12.3)).add(Float.valueOf(21.2f)).add(new BytesWritable(new byte[]{1, 2, 3}));
        Assert.assertEquals((Object)t1, (Object)t2);
        Assert.assertEquals((long)t1.hashCode(), (long)t2.hashCode());
    }

    @Test
    public void testMultiElementNotEqualsAndHash() throws Exception {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        t1.add("bob").add(Integer.valueOf(1)).add(Long.valueOf(2L)).add(Short.valueOf((short)3)).add(Boolean.valueOf(true)).add((String)null).add(Double.valueOf(12.3)).add(Float.valueOf(21.2f)).add(new BytesWritable(new byte[]{1, 2, 3}));
        t2.add("bob").add(Integer.valueOf(1)).add(Long.valueOf(2L)).add(Short.valueOf((short)3)).add(Boolean.valueOf(true)).add((String)null).add(Double.valueOf(12.3)).add(Float.valueOf(21.2f)).add(new BytesWritable(new byte[]{1, 2, 1}));
        Assert.assertNotSame((Object)t1, (Object)t2);
        Assert.assertNotSame((Object)t1.hashCode(), (Object)t2.hashCode());
    }

    @Test
    public void testGetMultipleElements() throws Exception {
        Tuple t1 = new Tuple();
        t1.add("bob").add(Integer.valueOf(1)).add(Long.valueOf(2L)).add(Short.valueOf((short)3)).add(Boolean.valueOf(true)).add((String)null).add(Double.valueOf(12.3)).add(Float.valueOf(21.2f)).add(new BytesWritable(new byte[]{1, 2, 3}));
        Assert.assertEquals((Object)"bob", (Object)t1.getString(0));
        Assert.assertEquals((long)1L, (long)t1.getInt(1).intValue());
        Assert.assertEquals((long)2L, (long)t1.getLong(2));
        Assert.assertEquals((long)3L, (long)t1.getShort(3).shortValue());
        Assert.assertTrue((boolean)t1.getBoolean(4));
        Assert.assertNull((Object)t1.getBoolean(5));
        Assert.assertEquals((double)12.3, (double)t1.getDouble(6), (double)0.01);
        Assert.assertEquals((double)21.2f, (double)t1.getFloat(7).floatValue(), (double)0.01);
        Assert.assertEquals((Object)new BytesWritable(new byte[]{1, 2, 3}), (Object)t1.getBytes(8));
    }

    @Test
    public void testEnumGetSet() throws Exception {
        Tuple t = new Tuple();
        t.set((Enum)TestEnum.THIRD, Integer.valueOf(5));
        Assert.assertEquals((long)5L, (long)t.getInt(2).intValue());
        Assert.assertEquals((long)5L, (long)t.getInt((Enum)TestEnum.THIRD).intValue());
        Assert.assertNull((Object)t.getObject(0));
        Assert.assertNull((Object)t.getObject(1));
        t.set((Enum)TestEnum.FIRST, "first");
        t.set((Enum)TestEnum.SECOND, Double.valueOf(3.4));
        Assert.assertEquals((Object)"first", (Object)t.getString(0));
        Assert.assertEquals((Object)"first", (Object)t.getString((Enum)TestEnum.FIRST));
        Assert.assertEquals((double)3.4, (double)t.getDouble(1), (double)0.1);
        Assert.assertEquals((double)3.4, (double)t.getDouble((Enum)TestEnum.SECOND), (double)0.1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetWithNegativeIndex() {
        new Tuple().getDouble(-1);
    }

    public void testPositiveIndexOutOfBounds() {
        Assert.assertNull((Object)new Tuple().getDouble(0));
    }

    @Test
    public void testSerialization() throws Exception {
        Tuple t1 = new Tuple();
        t1.add("bob").add(Integer.valueOf(1)).add(Long.valueOf(2L)).add(Short.valueOf((short)3)).add(Boolean.valueOf(true)).add((String)null).add(Double.valueOf(12.3)).add(Float.valueOf(21.2f)).add(new BytesWritable(new byte[]{1, 2, 3}));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(os);
        t1.write((DataOutput)dos);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(os.toByteArray()));
        Tuple t2 = new Tuple();
        t2.add("foo");
        t2.readFields((DataInput)dis);
        Assert.assertEquals((Object)t1, (Object)t2);
        Assert.assertEquals((Object)"bob", (Object)t2.getString(0));
        Assert.assertEquals((long)1L, (long)t2.getInt(1).intValue());
        Assert.assertEquals((long)2L, (long)t2.getLong(2));
        Assert.assertEquals((long)3L, (long)t2.getShort(3).shortValue());
        Assert.assertTrue((boolean)t2.getBoolean(4));
        Assert.assertNull((Object)t2.getBoolean(5));
        Assert.assertEquals((double)12.3, (double)t2.getDouble(6), (double)0.01);
        Assert.assertEquals((double)21.2f, (double)t2.getFloat(7).floatValue(), (double)0.01);
        Assert.assertEquals((Object)new BytesWritable(new byte[]{1, 2, 3}), (Object)t2.getBytes(8));
    }

    @Test
    public void testClear() throws Exception {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        t1.add("bob").add(Integer.valueOf(1)).add(Long.valueOf(2L)).add(Short.valueOf((short)3)).add(Boolean.valueOf(true)).add((String)null).add(Double.valueOf(12.3)).add(Float.valueOf(21.2f)).add(new BytesWritable(new byte[]{1, 2, 3}));
        Assert.assertNotSame((Object)t1, (Object)t2);
        t1.clear();
        Assert.assertEquals((Object)t1, (Object)t2);
    }

    @Test
    public void testCompareTo() throws Exception {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        t1.add("bob").add(Integer.valueOf(1)).add(Long.valueOf(2L)).add(Short.valueOf((short)3)).add(Boolean.valueOf(true)).add((String)null).add(Double.valueOf(12.3)).add(Float.valueOf(21.2f)).add(new BytesWritable(new byte[]{1, 2, 3}));
        t2.add("bob").add(Integer.valueOf(1)).add(Long.valueOf(2L)).add(Short.valueOf((short)3)).add(Boolean.valueOf(true)).add((String)null).add(Double.valueOf(12.3)).add(Float.valueOf(21.2f)).add(new BytesWritable(new byte[]{1, 2, 3}));
        Assert.assertEquals((long)0L, (long)t1.compareTo(t2));
    }

    @Test
    public void testEqualCompareTo() throws Exception {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        t1.add("alex");
        t2.add("alex");
        Assert.assertEquals((long)0L, (long)t1.compareTo(t2));
        t1.clear().add(Short.valueOf((short)1));
        t2.clear().add(Short.valueOf((short)1));
        Assert.assertEquals((long)0L, (long)t1.compareTo(t2));
        t1.clear().add(Integer.valueOf(1));
        t2.clear().add(Integer.valueOf(1));
        Assert.assertEquals((long)0L, (long)t1.compareTo(t2));
        t1.clear().add(Long.valueOf(1L));
        t2.clear().add(Long.valueOf(1L));
        Assert.assertEquals((long)0L, (long)t1.compareTo(t2));
        t1.clear().add(Double.valueOf(1.0));
        t2.clear().add(Double.valueOf(1.0));
        Assert.assertEquals((long)0L, (long)t1.compareTo(t2));
        t1.clear().add(Float.valueOf(1.0f));
        t2.clear().add(Float.valueOf(1.0f));
        Assert.assertEquals((long)0L, (long)t1.compareTo(t2));
        t1.clear().add(Boolean.valueOf(false));
        t2.clear().add(Boolean.valueOf(false));
        Assert.assertEquals((long)0L, (long)t1.compareTo(t2));
        t1.clear().add(Boolean.valueOf(true));
        t2.clear().add(Boolean.valueOf(true));
        Assert.assertEquals((long)0L, (long)t1.compareTo(t2));
        t1.clear().add(new BytesWritable(new byte[]{1, 2, 3}));
        t2.clear().add(new BytesWritable(new byte[]{1, 2, 3}));
        Assert.assertEquals((long)0L, (long)t1.compareTo(t2));
        t1.clear().add((Integer)null);
        t2.clear().add((Integer)null);
        Assert.assertEquals((long)0L, (long)t1.compareTo(t2));
        t1.clear().add(Integer.valueOf(1)).add(Integer.valueOf(2));
        t2.clear().add(Integer.valueOf(1)).add(Integer.valueOf(2));
        Assert.assertEquals((long)0L, (long)t1.compareTo(t2));
    }

    @Test
    public void testLhsLessThanCompareTo() throws Exception {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        t1.add("alex");
        t2.add("bob");
        Assert.assertTrue((t1.compareTo(t2) < 0 ? 1 : 0) != 0);
        t1.clear().add(Short.valueOf((short)1));
        t2.clear().add(Short.valueOf((short)2));
        Assert.assertTrue((t1.compareTo(t2) < 0 ? 1 : 0) != 0);
        t1.clear().add(Integer.valueOf(1));
        t2.clear().add(Integer.valueOf(2));
        Assert.assertTrue((t1.compareTo(t2) < 0 ? 1 : 0) != 0);
        t1.clear().add(Long.valueOf(1L));
        t2.clear().add(Long.valueOf(2L));
        Assert.assertTrue((t1.compareTo(t2) < 0 ? 1 : 0) != 0);
        t1.clear().add(Double.valueOf(1.0));
        t2.clear().add(Double.valueOf(2.0));
        Assert.assertTrue((t1.compareTo(t2) < 0 ? 1 : 0) != 0);
        t1.clear().add(Float.valueOf(1.0f));
        t2.clear().add(Float.valueOf(2.0f));
        Assert.assertTrue((t1.compareTo(t2) < 0 ? 1 : 0) != 0);
        t1.clear().add(Boolean.valueOf(false));
        t2.clear().add(Boolean.valueOf(true));
        Assert.assertTrue((t1.compareTo(t2) < 0 ? 1 : 0) != 0);
        t1.clear().add(new BytesWritable(new byte[]{1, 2, 3}));
        t2.clear().add(new BytesWritable(new byte[]{2}));
        Assert.assertTrue((t1.compareTo(t2) < 0 ? 1 : 0) != 0);
        t1.clear().add((Integer)null);
        t2.clear().add(new BytesWritable(new byte[]{2}));
        Assert.assertTrue((t1.compareTo(t2) < 0 ? 1 : 0) != 0);
        t1.clear().add(Integer.valueOf(1));
        t2.clear().add(Integer.valueOf(1)).add(Integer.valueOf(2));
        Assert.assertTrue((t1.compareTo(t2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLhsGreaterThanCompareTo() throws Exception {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        t1.add("alex");
        t2.add("bob");
        Assert.assertTrue((t2.compareTo(t1) > 0 ? 1 : 0) != 0);
        t1.clear().add(Short.valueOf((short)1));
        t2.clear().add(Short.valueOf((short)2));
        Assert.assertTrue((t2.compareTo(t1) > 0 ? 1 : 0) != 0);
        t1.clear().add(Integer.valueOf(1));
        t2.clear().add(Integer.valueOf(2));
        Assert.assertTrue((t2.compareTo(t1) > 0 ? 1 : 0) != 0);
        t1.clear().add(Long.valueOf(1L));
        t2.clear().add(Long.valueOf(2L));
        Assert.assertTrue((t2.compareTo(t1) > 0 ? 1 : 0) != 0);
        t1.clear().add(Double.valueOf(1.0));
        t2.clear().add(Double.valueOf(2.0));
        Assert.assertTrue((t2.compareTo(t1) > 0 ? 1 : 0) != 0);
        t1.clear().add(Float.valueOf(1.0f));
        t2.clear().add(Float.valueOf(2.0f));
        Assert.assertTrue((t2.compareTo(t1) > 0 ? 1 : 0) != 0);
        t1.clear().add(Boolean.valueOf(false));
        t2.clear().add(Boolean.valueOf(true));
        Assert.assertTrue((t2.compareTo(t1) > 0 ? 1 : 0) != 0);
        t1.clear().add(new BytesWritable(new byte[]{1, 2, 3}));
        t2.clear().add(new BytesWritable(new byte[]{2}));
        Assert.assertTrue((t2.compareTo(t1) > 0 ? 1 : 0) != 0);
        t1.clear().add((Integer)null);
        t2.clear().add(new BytesWritable(new byte[]{2}));
        Assert.assertTrue((t2.compareTo(t1) > 0 ? 1 : 0) != 0);
        t1.clear().add(Integer.valueOf(1));
        t2.clear().add(Integer.valueOf(1)).add(Integer.valueOf(2));
        Assert.assertTrue((t2.compareTo(t1) > 0 ? 1 : 0) != 0);
    }

    static enum TestEnum {
        FIRST,
        SECOND,
        THIRD;

    }
}

