/*
 * Decompiled with CFR 0.152.
 */
package com.htuple;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mrunit.mapreduce.MapReduceDriver;
import org.htuple.ShuffleUtils;
import org.htuple.Tuple;
import org.junit.Before;
import org.junit.Test;

public class MapReduceTest {
    MapReduceDriver<Tuple, Tuple, Tuple, Tuple, Tuple, Tuple> mapReduceDriver;

    @Before
    public void setUp() {
        this.mapReduceDriver = MapReduceDriver.newMapReduceDriver((Mapper)new Mapper(), (Reducer)new CountingReducer());
    }

    @Test
    public void testSorting() throws IOException {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        t1.add("alex").add(Integer.valueOf(1)).add(Long.valueOf(3L)).add(Short.valueOf((short)3));
        t2.add("bob").add(Integer.valueOf(1)).add(Long.valueOf(2L)).add(Short.valueOf((short)3));
        Configuration conf = this.mapReduceDriver.getConfiguration();
        ShuffleUtils.configBuilder().setSortIndices(new int[]{2}).configure(conf);
        ((MapReduceDriver)((MapReduceDriver)((MapReduceDriver)((MapReduceDriver)this.mapReduceDriver.withInput((Object)t1, (Object)t1)).withInput((Object)t2, (Object)t2)).withOutput((Object)t2, (Object)((Tuple)WritableUtils.clone((Writable)t2, (Configuration)conf)).add(Integer.valueOf(0)))).withOutput((Object)t1, (Object)((Tuple)WritableUtils.clone((Writable)t1, (Configuration)conf)).add(Integer.valueOf(0)))).runTest(true);
    }

    @Test
    public void testGrouping() throws IOException {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        Tuple t3 = new Tuple();
        t1.add("alex").add(Integer.valueOf(1)).add(Long.valueOf(2L)).add(Short.valueOf((short)3));
        t2.add("alex").add(Integer.valueOf(2)).add(Long.valueOf(2L)).add(Short.valueOf((short)3));
        t3.add("bob").add(Integer.valueOf(2)).add(Long.valueOf(2L)).add(Short.valueOf((short)3));
        Configuration conf = this.mapReduceDriver.getConfiguration();
        ShuffleUtils.configBuilder().setSortIndices(new int[]{0, 1, 2, 3}).setGroupIndices(new int[]{0}).configure(conf);
        ((MapReduceDriver)((MapReduceDriver)((MapReduceDriver)((MapReduceDriver)((MapReduceDriver)((MapReduceDriver)this.mapReduceDriver.withInput((Object)t2, (Object)t2)).withInput((Object)t1, (Object)t1)).withInput((Object)t3, (Object)t3)).withOutput((Object)t1, (Object)((Tuple)WritableUtils.clone((Writable)t1, (Configuration)conf)).add(Integer.valueOf(0)))).withOutput((Object)t1, (Object)((Tuple)WritableUtils.clone((Writable)t2, (Configuration)conf)).add(Integer.valueOf(1)))).withOutput((Object)t3, (Object)((Tuple)WritableUtils.clone((Writable)t3, (Configuration)conf)).add(Integer.valueOf(0)))).runTest(true);
    }

    public static class CountingReducer
    extends Reducer<Tuple, Tuple, Tuple, Tuple> {
        protected void reduce(Tuple key, Iterable<Tuple> values, Reducer.Context context) throws IOException, InterruptedException {
            int count = 0;
            for (Tuple value : values) {
                context.write((Object)key, (Object)value.add(Integer.valueOf(count++)));
            }
        }
    }
}

