/*
 * Decompiled with CFR 0.152.
 */
package com.htuple;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparable;
import org.htuple.Tuple;
import org.htuple.TupleComparator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractTupleComparatorTest {
    TupleComparator comparator;
    String configName;
    Configuration conf;

    public abstract TupleComparator getComparator();

    public abstract String getConfigName();

    public abstract void setComparatorIndices(Configuration var1, int ... var2);

    @Before
    public void setup() {
        this.comparator = this.getComparator();
        this.configName = this.getConfigName();
        this.conf = new Configuration();
    }

    @Test(expected=IllegalStateException.class)
    public void testNoConfigSetOnSort() {
        this.comparator.setConf(new Configuration());
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyConfigOnSort() {
        this.conf.setStrings(this.configName, new String[]{""});
        this.comparator.setConf(this.conf);
    }

    @Test
    public void testDifferentSizes() {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        t1.add("alex");
        t2.add("alex").add(Integer.valueOf(1));
        this.setComparatorIndices(this.conf, 0);
        this.comparator.setConf(this.conf);
        Assert.assertTrue((this.comparator.compare((WritableComparable)t1, (WritableComparable)t2) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMatchMulti() {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        t1.add("alex").add(Integer.valueOf(1)).add(Integer.valueOf(3));
        t2.add("alex").add(Integer.valueOf(2)).add(Integer.valueOf(2));
        this.setComparatorIndices(this.conf, 0);
        this.comparator.setConf(this.conf);
        Assert.assertTrue((this.comparator.compare((WritableComparable)t1, (WritableComparable)t2) == 0 ? 1 : 0) != 0);
        this.setComparatorIndices(this.conf, 1);
        this.comparator.setConf(this.conf);
        Assert.assertTrue((this.comparator.compare((WritableComparable)t1, (WritableComparable)t2) < 0 ? 1 : 0) != 0);
        this.setComparatorIndices(this.conf, 2);
        this.comparator.setConf(this.conf);
        Assert.assertTrue((this.comparator.compare((WritableComparable)t1, (WritableComparable)t2) > 0 ? 1 : 0) != 0);
        this.setComparatorIndices(this.conf, 0, 1);
        this.comparator.setConf(this.conf);
        Assert.assertTrue((this.comparator.compare((WritableComparable)t1, (WritableComparable)t2) < 0 ? 1 : 0) != 0);
        this.setComparatorIndices(this.conf, 0, 2);
        this.comparator.setConf(this.conf);
        Assert.assertTrue((this.comparator.compare((WritableComparable)t1, (WritableComparable)t2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOrdering() {
        Tuple t1 = new Tuple();
        Tuple t2 = new Tuple();
        t1.add("alex").add(Integer.valueOf(1)).add(Integer.valueOf(3));
        t2.add("alex").add(Integer.valueOf(2)).add(Integer.valueOf(2));
        this.setComparatorIndices(this.conf, 2, 1);
        this.comparator.setConf(this.conf);
        Assert.assertTrue((this.comparator.compare((WritableComparable)t1, (WritableComparable)t2) > 0 ? 1 : 0) != 0);
    }
}

