/*
 * Decompiled with CFR 0.152.
 */
package org.httpobjects.servlet.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.httpobjects.Representation;
import org.httpobjects.data.DataSource;
import org.httpobjects.data.OutputStreamDataSource;

public class LazyRep
implements Representation {
    private final String contentType;
    private final InputStream input;
    private byte[] data;

    public LazyRep(String contentType, InputStream inputStream) {
        this.contentType = contentType;
        this.input = inputStream;
        this.data = null;
    }

    private byte[] getData() throws Exception {
        if (this.data == null) {
            if (this.input == null) {
                this.data = new byte[0];
            } else {
                int n;
                byte[] b = new byte[256];
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                while ((n = this.input.read(b)) != -1) {
                    buf.write(b, 0, n);
                }
                this.input.close();
                this.data = buf.toByteArray();
            }
        }
        return this.data;
    }

    public String contentType() {
        return this.contentType;
    }

    public DataSource data() {
        return new OutputStreamDataSource(out -> {
            try {
                out.write(this.getData());
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        });
    }

    public String toString() {
        return "LazyRep(" + this.contentType + "," + (this.data == null ? "[not-yet-read]" : new String(this.data, StandardCharsets.UTF_8)) + ")";
    }
}

