/*
 * Decompiled with CFR 0.152.
 */
package org.httpobjects.servlet.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.httpobjects.ConnectionInfo;
import org.httpobjects.header.HeaderField;
import org.httpobjects.header.request.RequestHeader;
import org.httpobjects.header.response.SetCookieField;

public class HttpServletRequestUtil {
    public static ConnectionInfo connectionInfo(HttpServletRequest request) {
        return new ConnectionInfo(request.getLocalAddr(), Integer.valueOf(request.getLocalPort()), request.getRemoteAddr(), Integer.valueOf(request.getRemotePort()));
    }

    public static List<SetCookieField> buildCookies(HttpServletRequest request) {
        List<SetCookieField> cookies;
        Cookie[] servletCookies = request.getCookies();
        if (servletCookies == null) {
            cookies = Collections.emptyList();
        } else {
            cookies = new ArrayList<SetCookieField>(servletCookies.length);
            for (Cookie next : servletCookies) {
                cookies.add(HttpServletRequestUtil.buildCookie(next));
            }
        }
        return cookies;
    }

    public static SetCookieField buildCookie(Cookie next) {
        return new SetCookieField(next.getName(), next.getValue(), next.getDomain(), next.getPath(), null, Boolean.valueOf(next.getSecure()));
    }

    public static RequestHeader buildHeader(HttpServletRequest request) {
        ArrayList<HeaderField> fields = new ArrayList<HeaderField>();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getHeader(name);
            fields.add(HeaderField.parse((String)name, (String)value));
        }
        return new RequestHeader(fields);
    }
}

