/*
 * Decompiled with CFR 0.152.
 */
package org.httpobjects.servlet.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.httpobjects.Representation;
import org.httpobjects.representation.ImmutableRep;

public class LazyHttpServletRequestRepresentation {
    public static Representation of(HttpServletRequest request, int tries) {
        try {
            String contentType = request.getContentType();
            ServletInputStream input = request.getInputStream();
            Object data = input != null ? input : new ByteArrayInputStream(new byte[0]);
            return new ImmutableRep(contentType, (InputStream)data);
        }
        catch (IOException err) {
            if (tries > 10) {
                throw new RuntimeException(err);
            }
            return LazyHttpServletRequestRepresentation.of(request, tries + 1);
        }
    }
}

