/*
 * Decompiled with CFR 0.152.
 */
package org.httpobjects.servlet.impl;

import javax.servlet.http.HttpServletRequest;
import org.httpobjects.ConnectionInfo;
import org.httpobjects.Query;
import org.httpobjects.Representation;
import org.httpobjects.Request;
import org.httpobjects.header.request.RequestHeader;
import org.httpobjects.path.Path;
import org.httpobjects.servlet.impl.HttpServletRequestUtil;
import org.httpobjects.servlet.impl.ImmutableHttpServletRequestRepresentation;
import org.httpobjects.util.Method;

public class ImmutableRequestImpl
implements Request {
    private final Path vars;
    private final String contentType;
    private final String query;
    private final RequestHeader header;
    private final Representation representation;
    private final ConnectionInfo connectionInfo;
    private final Method method;

    public ImmutableRequestImpl(Path vars, HttpServletRequest request) {
        this.vars = vars;
        this.contentType = request.getContentType();
        this.query = request.getQueryString();
        this.connectionInfo = HttpServletRequestUtil.connectionInfo(request);
        this.header = HttpServletRequestUtil.buildHeader(request);
        this.representation = ImmutableHttpServletRequestRepresentation.of(request, 0);
        this.method = Method.fromString((String)request.getMethod().toUpperCase());
    }

    public Method method() {
        return this.method;
    }

    public Path path() {
        return this.vars;
    }

    public String contentType() {
        return this.contentType;
    }

    public boolean hasRepresentation() {
        return true;
    }

    public Query query() {
        return new Query(this.query);
    }

    public RequestHeader header() {
        return this.header;
    }

    public Representation representation() {
        return this.representation;
    }

    public Request immutableCopy() {
        return this;
    }

    public ConnectionInfo connectionInfo() {
        return this.connectionInfo;
    }
}

