/*
 * Decompiled with CFR 0.152.
 */
package org.httpobjects.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.httpobjects.HttpObject;
import org.httpobjects.Representation;
import org.httpobjects.Request;
import org.httpobjects.Response;
import org.httpobjects.header.GenericHeaderField;
import org.httpobjects.header.HeaderField;
import org.httpobjects.header.HeaderFieldVisitor;
import org.httpobjects.header.request.AuthorizationField;
import org.httpobjects.header.request.CookieField;
import org.httpobjects.header.response.AllowField;
import org.httpobjects.header.response.LocationField;
import org.httpobjects.header.response.SetCookieField;
import org.httpobjects.header.response.WWWAuthenticateField;
import org.httpobjects.servlet.PathMatchObserver;
import org.httpobjects.servlet.impl.LazyRequestImpl;
import org.httpobjects.util.HttpObjectUtil;
import org.httpobjects.util.Method;

public class ServletMethodInvoker {
    private final HttpObject[] objects;
    private final Response notFoundResponse;
    private final List<? extends HeaderField> defaultResponseHeaders;
    private final PathMatchObserver pathMatchObserver;

    public ServletMethodInvoker(HttpObject[] objects) {
        this(HttpObject.NOT_FOUND((Representation)HttpObject.Text((String)"Error: NOT_FOUND")), objects);
    }

    public ServletMethodInvoker(Response notFoundResponse, HttpObject[] objects) {
        this(Collections.emptyList(), notFoundResponse, objects);
    }

    public ServletMethodInvoker(List<? extends HeaderField> defaultResponseHeader, Response notFoundResponse, HttpObject[] objects) {
        this(PathMatchObserver.DO_NOTHING, defaultResponseHeader, notFoundResponse, objects);
    }

    public ServletMethodInvoker(PathMatchObserver pathMatchObserver, List<? extends HeaderField> defaultResponseHeader, Response notFoundResponse, HttpObject[] objects) {
        this.pathMatchObserver = pathMatchObserver;
        this.notFoundResponse = notFoundResponse;
        this.objects = objects;
        this.defaultResponseHeaders = defaultResponseHeader;
    }

    public boolean invokeFirstPathMatchIfAble(String path, HttpServletRequest r, HttpServletResponse httpResponse) {
        Response lastResponse = null;
        for (HttpObject next : this.objects) {
            this.pathMatchObserver.checkingPathAgainstPattern(path, next.pattern());
            if (!next.pattern().matches(path) || (lastResponse = this.invoke(r, httpResponse, next)) == null) continue;
            this.pathMatchObserver.pathMatchedPattern(path, next.pattern());
            this.returnResponse(lastResponse, httpResponse);
            break;
        }
        if (lastResponse != null) {
            return true;
        }
        if (this.notFoundResponse != null) {
            this.returnResponse(this.notFoundResponse, httpResponse);
            return true;
        }
        return false;
    }

    private Response invoke(HttpServletRequest r, HttpServletResponse httpResponse, HttpObject object) {
        Method m = Method.fromString((String)r.getMethod());
        LazyRequestImpl input = new LazyRequestImpl(object.pattern().match(r.getRequestURI()), r);
        return HttpObjectUtil.invokeMethod((HttpObject)object, (Method)m, (Request)input);
    }

    private void returnResponse(Response r, final HttpServletResponse resp) {
        try {
            resp.setStatus(r.code().value());
            for (HeaderField next : r.header()) {
                next.accept((HeaderFieldVisitor)new HeaderFieldVisitor<Void>(){

                    public Void visit(CookieField cookieField) {
                        resp.setHeader(cookieField.name(), cookieField.value());
                        return null;
                    }

                    public Void visit(GenericHeaderField other) {
                        resp.setHeader(other.name(), other.value());
                        return null;
                    }

                    public Void visit(AllowField allowField) {
                        resp.setHeader(allowField.name(), allowField.value());
                        return null;
                    }

                    public Void visit(LocationField location) {
                        resp.setHeader(location.name(), location.value());
                        return null;
                    }

                    public Void visit(SetCookieField setCookieField) {
                        resp.addCookie(ServletMethodInvoker.this.translate(setCookieField));
                        return null;
                    }

                    public Void visit(WWWAuthenticateField wwwAuthorizationField) {
                        resp.setHeader(wwwAuthorizationField.name(), wwwAuthorizationField.value());
                        return null;
                    }

                    public Void visit(AuthorizationField authorizationField) {
                        throw new RuntimeException("Illegal header for request: " + authorizationField.getClass());
                    }
                });
            }
            this.addDefaultHeadersAsApplicable(r, resp);
            if (r.hasRepresentation()) {
                resp.setContentType(r.representation().contentType());
                ServletOutputStream out = resp.getOutputStream();
                r.representation().write((OutputStream)out);
                out.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addDefaultHeadersAsApplicable(Response r, HttpServletResponse resp) {
        for (HeaderField headerField : this.defaultResponseHeaders) {
            boolean exists = false;
            for (HeaderField header : r.header()) {
                if (!header.name().equals(headerField.name())) continue;
                exists = true;
            }
            if (exists) continue;
            resp.setHeader(headerField.name(), headerField.value());
        }
    }

    private Cookie translate(SetCookieField cookie) {
        Cookie c = new Cookie(cookie.name, cookie.value);
        if (cookie.domain != null) {
            c.setDomain(cookie.domain);
        }
        if (cookie.path != null) {
            c.setPath(cookie.path);
        }
        if (cookie.secure != null) {
            c.setSecure(cookie.secure.booleanValue());
        }
        return c;
    }
}

