/*
 * Decompiled with CFR 0.152.
 */
package org.httpobjects.servlet.impl;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.httpobjects.Query;
import org.httpobjects.Representation;
import org.httpobjects.Request;
import org.httpobjects.header.request.RequestHeader;
import org.httpobjects.header.response.SetCookieField;
import org.httpobjects.path.Path;
import org.httpobjects.servlet.impl.HttpServletRequestUtil;
import org.httpobjects.servlet.impl.ImmutableHttpServletRequestRepresentation;
import org.httpobjects.util.RequestQueryUtil;

public class ImmutableRequestImpl
implements Request {
    private final Path vars;
    private final String contentType;
    private final List<SetCookieField> cookies;
    private final String query;
    private final Map<String, String> parameters;
    private final RequestHeader header;
    private final Representation representation;

    public ImmutableRequestImpl(Path vars, HttpServletRequest request) {
        this.vars = vars;
        this.contentType = request.getContentType();
        this.cookies = Collections.unmodifiableList(HttpServletRequestUtil.buildCookies(request));
        this.query = request.getQueryString();
        try {
            this.parameters = Collections.unmodifiableMap(RequestQueryUtil.getUrlParameters((String)request.getQueryString()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.header = HttpServletRequestUtil.buildHeader(request);
        this.representation = new ImmutableHttpServletRequestRepresentation(request);
    }

    public Path path() {
        return this.vars;
    }

    public String contentType() {
        return this.contentType;
    }

    public boolean hasRepresentation() {
        return true;
    }

    public Query query() {
        return new Query(this.query);
    }

    public RequestHeader header() {
        return this.header;
    }

    public Representation representation() {
        return this.representation;
    }

    public Request immutableCopy() {
        return this;
    }
}

