/*
 * Decompiled with CFR 0.152.
 */
package org.httpobjects.servlet.impl;

import javax.servlet.http.HttpServletRequest;
import org.httpobjects.Query;
import org.httpobjects.Representation;
import org.httpobjects.Request;
import org.httpobjects.header.request.RequestHeader;
import org.httpobjects.path.Path;
import org.httpobjects.servlet.impl.HttpServletRequestUtil;
import org.httpobjects.servlet.impl.ImmutableRequestImpl;
import org.httpobjects.servlet.impl.LazyHttpServletRequestRepresentation;

public class LazyRequestImpl
implements Request {
    private final HttpServletRequest request;
    private final Path vars;

    public LazyRequestImpl(Path vars, HttpServletRequest request) {
        this.vars = vars;
        this.request = request;
    }

    private String queryOrEmpty() {
        String query = this.request.getQueryString();
        if (query == null) {
            return "";
        }
        return "?" + query;
    }

    public Path path() {
        return this.vars;
    }

    public String contentType() {
        return this.request.getContentType();
    }

    public boolean hasRepresentation() {
        return true;
    }

    public Query query() {
        return new Query(this.request.getQueryString());
    }

    public RequestHeader header() {
        return HttpServletRequestUtil.buildHeader(this.request);
    }

    public Representation representation() {
        return new LazyHttpServletRequestRepresentation(this.request);
    }

    public Request immutableCopy() {
        return new ImmutableRequestImpl(this.vars, this.request);
    }
}

