/*
 * Decompiled with CFR 0.152.
 */
package org.httpobjects.servlet.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.httpobjects.Representation;

public class ImmutableHttpServletRequestRepresentation
implements Representation {
    private final String contentType;
    private final byte[] content;

    public ImmutableHttpServletRequestRepresentation(HttpServletRequest request) {
        try {
            ServletInputStream in = request.getInputStream();
            if (in != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImmutableHttpServletRequestRepresentation.copy((InputStream)in, out);
                this.content = out.toByteArray();
            } else {
                this.content = new byte[0];
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.contentType = request.getContentType();
    }

    private static void copy(InputStream in, OutputStream out) {
        try {
            byte[] buffer = new byte[10240];
            int x = in.read(buffer);
            while (x != -1) {
                out.write(buffer, 0, x);
                x = in.read(buffer);
            }
            out.close();
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(OutputStream out) {
        ImmutableHttpServletRequestRepresentation.copy(new ByteArrayInputStream(this.content), out);
    }

    public String contentType() {
        return this.contentType;
    }
}

