/*
 * Decompiled with CFR 0.152.
 */
package org.httpobjects.servlet.impl;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.httpobjects.Representation;
import org.httpobjects.Request;
import org.httpobjects.header.request.RequestHeader;
import org.httpobjects.header.response.SetCookieField;
import org.httpobjects.path.PathVariables;
import org.httpobjects.servlet.impl.HttpServletRequestUtil;
import org.httpobjects.servlet.impl.ImmutableRequestImpl;
import org.httpobjects.servlet.impl.LazyHttpServletRequestRepresentation;

public class LazyRequestImpl
implements Request {
    private final HttpServletRequest request;
    private final PathVariables vars;

    public LazyRequestImpl(PathVariables vars, HttpServletRequest request) {
        this.vars = vars;
        this.request = request;
    }

    public PathVariables pathVars() {
        return this.vars;
    }

    public String contentType() {
        return this.request.getContentType();
    }

    public boolean hasRepresentation() {
        return true;
    }

    public List<SetCookieField> cookies() {
        return HttpServletRequestUtil.buildCookies(this.request);
    }

    public String query() {
        return this.request.getQueryString();
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public RequestHeader header() {
        return HttpServletRequestUtil.buildHeader(this.request);
    }

    public Representation representation() {
        return new LazyHttpServletRequestRepresentation(this.request);
    }

    public Request immutableCopy() {
        return new ImmutableRequestImpl(this.vars, this.request);
    }
}

