/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.thirdpart.ueditor;

import com.baidu.ueditor.ActionEnter;
import com.baidu.ueditor.Context;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.hswebframework.web.service.file.FileInfoService;
import org.hswebframework.web.service.file.FileService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/ueditor"})
@Api(tags={"\u7b2c\u4e09\u65b9\u5e94\u7528-ueditor"}, value="ueditor")
public class UeditorController {
    @Resource
    private FileService fileService;
    @Resource
    private FileInfoService resourcesService;
    @Value(value="${ueditor.root-path:/}")
    private String rootPath = "/";

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    @PostConstruct
    public void init() {
        Context.FILE_SERVICE = this.fileService;
        Context.RESOURCES_SERVICE = this.resourcesService;
    }

    private String getDownloadPath(HttpServletRequest request) {
        return this.rootPath;
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    public String upload(@RequestParam(value="upfile", required=false) MultipartFile file) throws IOException {
        String fileName = file.getOriginalFilename();
        String suffix = FileType.getSuffixByFilename(fileName);
        String path = this.fileService.saveStaticFile(file.getInputStream(), System.currentTimeMillis() + suffix);
        BaseState state = new BaseState(true);
        state.putInfo("size", file.getSize());
        state.putInfo("title", fileName);
        state.putInfo("url", path);
        state.putInfo("type", suffix);
        state.putInfo("original", fileName);
        return state.toJSONString();
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    @ApiOperation(value="\u521d\u59cb\u5316\u914d\u7f6e")
    public String run(HttpServletRequest request) throws Exception {
        return new ActionEnter(request, this.getDownloadPath(request)).exec();
    }
}

