/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.Context;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.hswebframework.web.service.file.FileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Base64Uploader {
    private static final Logger log = LoggerFactory.getLogger(Base64Uploader.class);

    public static State save(String content, Map<String, Object> conf) {
        long maxSize;
        byte[] data = Base64Uploader.decode(content);
        if (!Base64Uploader.validSize(data, maxSize = ((Long)conf.get("maxSize")).longValue())) {
            return new BaseState(false, 1);
        }
        String suffix = FileType.getSuffix("JPG");
        try {
            FileService fileService = Context.FILE_SERVICE;
            String path = fileService.saveStaticFile((InputStream)new ByteArrayInputStream(data), System.currentTimeMillis() + suffix);
            BaseState state = new BaseState(true);
            state.putInfo("size", data.length);
            state.putInfo("title", "");
            state.putInfo("url", path);
            state.putInfo("type", suffix);
            return state;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20base64\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return new BaseState(false, 4);
        }
    }

    private static byte[] decode(String content) {
        return Base64.decodeBase64((String)content);
    }

    private static boolean validSize(byte[] data, long length) {
        return (long)data.length <= length;
    }
}

