/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.Context;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.hswebframework.web.service.file.FileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryUploader {
    private static final Logger log = LoggerFactory.getLogger(BinaryUploader.class);

    public static final State save(HttpServletRequest request, Map<String, Object> conf) {
        boolean isAjaxUpload;
        FileItemStream fileStream = null;
        boolean bl = isAjaxUpload = request.getHeader("X_Requested_With") != null;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return new BaseState(false, 5);
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        if (isAjaxUpload) {
            upload.setHeaderEncoding("UTF-8");
        }
        try {
            FileItemIterator iterator = upload.getItemIterator(request);
            while (iterator.hasNext() && (fileStream = iterator.next()).isFormField()) {
                fileStream = null;
            }
            if (fileStream == null) {
                return new BaseState(false, 7);
            }
            String savePath = (String)conf.get("savePath");
            String originFileName = fileStream.getName();
            String suffix = FileType.getSuffixByFilename(originFileName);
            originFileName = originFileName.substring(0, originFileName.length() - suffix.length());
            if (!BinaryUploader.validType(suffix, (String[])conf.get("allowFiles"))) {
                return new BaseState(false, 8);
            }
            InputStream is = fileStream.openStream();
            try {
                FileService fileService = Context.FILE_SERVICE;
                String path = fileService.saveStaticFile(is, originFileName + suffix);
                BaseState state = new BaseState(true);
                state.putInfo("size", 0L);
                state.putInfo("title", originFileName + suffix);
                state.putInfo("url", path);
                state.putInfo("type", suffix);
                state.putInfo("original", originFileName + suffix);
                return state;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (FileUploadException e) {
            return new BaseState(false, 6);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new BaseState(false, 4);
    }

    private static boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);
        return list.contains(type);
    }
}

