/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.service.imp;

import java.io.InputStream;
import java.util.List;
import java.util.function.Consumer;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.engine.runtime.Job;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.NotFoundException;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.workflow.dao.entity.ProcessHistoryEntity;
import org.hswebframework.web.workflow.service.BpmProcessService;
import org.hswebframework.web.workflow.service.BpmTaskService;
import org.hswebframework.web.workflow.service.ProcessHistoryService;
import org.hswebframework.web.workflow.service.WorkFlowFormService;
import org.hswebframework.web.workflow.service.imp.AbstractFlowableService;
import org.hswebframework.web.workflow.service.request.SaveFormRequest;
import org.hswebframework.web.workflow.service.request.StartProcessRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Throwable.class})
public class BpmProcessServiceImpl
extends AbstractFlowableService
implements BpmProcessService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BpmTaskService bpmTaskService;
    @Autowired
    private WorkFlowFormService workFlowFormService;
    @Autowired
    private ProcessHistoryService processHistoryService;

    @Override
    public List<ProcessDefinition> getAllProcessDefinition() {
        return this.repositoryService.createProcessDefinitionQuery().latestVersion().active().list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessInstance startProcessInstance(StartProcessRequest request) {
        ProcessInstance processInstance;
        request.tryValidate(new Class[0]);
        this.logger.debug("start workflow :{}", (Object)request);
        try {
            this.identityService.setAuthenticatedUserId(request.getCreatorId());
            ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(request.getProcessDefineId()).singleResult();
            if (definition == null) {
                throw new NotFoundException("\u6d41\u7a0b[" + request.getProcessDefineId() + "]\u4e0d\u5b58\u5728");
            }
            String businessKey = (String)IDGenerator.MD5.generate();
            processInstance = this.runtimeService.startProcessInstanceById(request.getProcessDefineId(), businessKey, request.getVariables());
            Consumer<Task> candidateUserSetter = task -> {
                if (task == null) {
                    return;
                }
                if (!StringUtils.isNullOrEmpty((Object)request.getNextClaimUserId())) {
                    this.taskService.addCandidateUser(task.getId(), request.getNextClaimUserId());
                } else {
                    this.bpmTaskService.setCandidate(request.getCreatorId(), (Task)task);
                }
            };
            List<Task> tasks = this.bpmTaskService.selectTaskByProcessId(processInstance.getProcessDefinitionId());
            String activityId = processInstance.getActivityId();
            if (activityId == null) {
                tasks.forEach(candidateUserSetter);
            } else {
                candidateUserSetter.accept((Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).taskDefinitionKey(activityId)).active().singleResult());
            }
            this.workFlowFormService.saveProcessForm(processInstance, SaveFormRequest.builder().userId(request.getCreatorId()).userName(request.getCreatorName()).formData(request.getFormData()).build());
            ProcessHistoryEntity history = ProcessHistoryEntity.builder().type("start").typeText("\u542f\u52a8\u6d41\u7a0b").businessKey(businessKey).creatorId(request.getCreatorId()).creatorName(request.getCreatorName()).processInstanceId(processInstance.getProcessInstanceId()).processDefineId(processInstance.getProcessDefinitionId()).build();
            this.processHistoryService.insert((Object)history);
        }
        finally {
            this.identityService.setAuthenticatedUserId(null);
        }
        return processInstance;
    }

    @Override
    public void closeProcessInstance(String processInstanceId) {
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
    }

    @Override
    public void openProcessInstance(String processInstanceId) {
        this.runtimeService.activateProcessInstanceById(processInstanceId);
    }

    @Override
    public ProcessDefinition getProcessDefinitionById(String processDefinitionId) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
    }

    @Override
    public ProcessDefinition getProcessDefinitionByKey(String procDefKey) {
        return (ProcessDefinition)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(procDefKey).orderByProcessDefinitionVersion().desc()).list().get(0);
    }

    @Override
    public InputStream findProcessPic(String procDefId) {
        ProcessDefinition definition = this.getProcessDefinitionById(procDefId);
        String source = definition.getDiagramResourceName();
        return this.repositoryService.getResourceAsStream(definition.getDeploymentId(), source);
    }

    @Override
    public Job getJob(String processInstanceId) {
        return (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
    }

    @Override
    public int deleteJob(String jobId) {
        return 0;
    }
}

