/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.flowable;

import java.util.List;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.impl.interceptor.SessionFactory;
import org.activiti.spring.boot.ProcessEngineConfigurationConfigurer;
import org.hswebframework.web.dao.Dao;
import org.hswebframework.web.service.authorization.UserService;
import org.hswebframework.web.workflow.flowable.utils.CustomGroupEntityManager;
import org.hswebframework.web.workflow.flowable.utils.CustomGroupEntityManagerFactory;
import org.hswebframework.web.workflow.flowable.utils.CustomUserEntityManager;
import org.hswebframework.web.workflow.flowable.utils.CustomUserEntityManagerFactory;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={CustomEntityManagerAutoConfiguration.class})
@MapperScan(value={"org.hswebframework.web.workflow.dao"}, markerInterface=Dao.class, sqlSessionFactoryRef="sqlSessionFactory")
public class FlowableAutoConfiguration {
    @Autowired(required=false)
    private List<SessionFactory> sessionFactories;
    @Autowired(required=false)
    private List<ActivitiEventListener> activitiEventListeners;

    @Bean
    public ProcessEngineConfigurationConfigurer processEngineConfigurationConfigurer() {
        return configuration -> {
            configuration.setAsyncExecutorActivate(false).setJobExecutorActivate(false).setActivityFontName("\u5b8b\u4f53").setLabelFontName("\u5b8b\u4f53").setAnnotationFontName("\u5b8b\u4f53");
            if (this.activitiEventListeners != null) {
                configuration.setEventListeners(this.activitiEventListeners);
            }
            if (this.sessionFactories != null) {
                configuration.setCustomSessionFactories(this.sessionFactories);
            }
        };
    }

    @ConditionalOnBean(value={UserService.class})
    @Configuration
    public static class CustomEntityManagerAutoConfiguration {
        @Autowired
        private UserService userService;

        @Bean
        public CustomGroupEntityManagerFactory customGroupEntityManagerFactory() {
            return new CustomGroupEntityManagerFactory(new CustomGroupEntityManager(this.userService));
        }

        @Bean
        public CustomUserEntityManagerFactory customUserEntityManagerFactory() {
            return new CustomUserEntityManagerFactory(new CustomUserEntityManager(this.userService));
        }
    }
}

