/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.persistence.entity.ModelEntity;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.hswebframework.web.NotFoundException;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.commons.entity.PagerResult;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.workflow.enums.ModelType;
import org.hswebframework.web.workflow.util.QueryUtils;
import org.hswebframework.web.workflow.web.request.ModelCreateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workflow/model"})
@Api(tags={"\u5de5\u4f5c\u6d41-\u6a21\u578b\u7ba1\u7406"}, description="\u5de5\u4f5c\u6d41\u6a21\u578b\u7ba1\u7406")
@Authorize(permission={"workflow-model"}, description={"\u5de5\u4f5c\u6d41\u6a21\u578b\u7ba1\u7406"})
public class FlowableModelManagerController {
    private static final Logger log = LoggerFactory.getLogger(FlowableModelManagerController.class);
    @Autowired
    private RepositoryService repositoryService;
    private static final String MODEL_ID = "modelId";
    private static final String MODEL_NAME = "name";
    private static final String MODEL_REVISION = "revision";
    private static final String MODEL_DESCRIPTION = "description";
    private static final String MODEL_KEY = "key";

    @GetMapping
    @Authorize(action={"query"})
    @ApiOperation(value="\u83b7\u53d6\u6a21\u578b\u5217\u8868")
    public ResponseMessage<PagerResult<Model>> getModelList(QueryParamEntity param) {
        ModelQuery modelQuery = this.repositoryService.createModelQuery();
        return ResponseMessage.ok(QueryUtils.doQuery(modelQuery, param, model -> (ModelEntity)FastBeanCopier.copy((Object)model, (Object)new ModelEntity(), (String[])new String[0]), (term, modelQuery1) -> {
            if ("latestVersion".equals(term.getColumn())) {
                modelQuery1.latestVersion();
            }
        }));
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u521b\u5efa\u6a21\u578b")
    public ResponseMessage<Model> createModel(@RequestBody ModelCreateRequest model) throws Exception {
        JSONObject stencilset = new JSONObject();
        stencilset.put("namespace", (Object)"http://b3mn.org/stencilset/bpmn2.0#");
        JSONObject editorNode = new JSONObject();
        editorNode.put("id", (Object)"canvas");
        editorNode.put("resourceId", (Object)"canvas");
        editorNode.put("stencilset", (Object)stencilset);
        JSONObject modelObjectNode = new JSONObject();
        modelObjectNode.put(MODEL_REVISION, (Object)1);
        modelObjectNode.put(MODEL_DESCRIPTION, (Object)model.getDescription());
        modelObjectNode.put(MODEL_KEY, (Object)model.getKey());
        modelObjectNode.put(MODEL_NAME, (Object)model.getName());
        Model modelData = this.repositoryService.newModel();
        modelData.setMetaInfo(modelObjectNode.toJSONString());
        modelData.setName(model.getName());
        modelData.setKey(model.getKey());
        this.repositoryService.saveModel(modelData);
        this.repositoryService.addModelEditorSource(modelData.getId(), editorNode.toString().getBytes("utf-8"));
        return ResponseMessage.ok((Object)modelData).status(201);
    }

    @PostMapping(value={"/{modelId}/deploy"})
    @ApiOperation(value="\u53d1\u5e03\u6a21\u578b")
    @Authorize(action={"deploy"})
    public ResponseMessage<Deployment> deployModel(@PathVariable String modelId) throws Exception {
        Model modelData = this.repositoryService.getModel(modelId);
        if (modelData == null) {
            throw new NotFoundException("\u6a21\u578b\u4e0d\u5b58\u5728!");
        }
        ObjectNode modelNode = (ObjectNode)new ObjectMapper().readTree(this.repositoryService.getModelEditorSource(modelData.getId()));
        BpmnModel model = new BpmnJsonConverter().convertToBpmnModel((JsonNode)modelNode);
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(model);
        String processName = modelData.getName() + ".bpmn20.xml";
        Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, "utf8")).deploy();
        return ResponseMessage.ok((Object)deployment).include(Deployment.class, new String[]{"id", MODEL_NAME, "new"});
    }

    @GetMapping(value={"export/{modelId}/{type}"})
    @ApiOperation(value="\u5bfc\u51fa\u6a21\u578b")
    @Authorize(action={"export"})
    public void export(@PathVariable(value="modelId") @ApiParam(value="\u6a21\u578bID") String modelId, @PathVariable(value="type") @ApiParam(value="\u7c7b\u578b", allowableValues="bpmn,json", example="json") ModelType type, @ApiParam(hidden=true) HttpServletResponse response) {
        Model modelData = this.repositoryService.getModel(modelId);
        if (modelData == null) {
            throw new NotFoundException("\u6a21\u578b\u4e0d\u5b58\u5728");
        }
        BpmnJsonConverter jsonConverter = new BpmnJsonConverter();
        byte[] modelEditorSource = this.repositoryService.getModelEditorSource(modelData.getId());
        JsonNode editorNode = new ObjectMapper().readTree(modelEditorSource);
        BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editorNode);
        if (bpmnModel.getMainProcess() == null) {
            throw new UnsupportedOperationException("\u65e0\u6cd5\u5bfc\u51fa\u6a21\u578b\u6587\u4ef6:" + (Object)((Object)type));
        }
        String filename = "";
        byte[] exportBytes = null;
        String mainProcessId = bpmnModel.getMainProcess().getId();
        if (type == ModelType.bpmn) {
            BpmnXMLConverter xmlConverter = new BpmnXMLConverter();
            exportBytes = xmlConverter.convertToXML(bpmnModel);
            filename = mainProcessId + ".bpmn20.xml";
        } else if (type == ModelType.json) {
            exportBytes = modelEditorSource;
            filename = mainProcessId + ".json";
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u683c\u5f0f:" + (Object)((Object)type));
        }
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(filename, "UTF-8"));
        try (ByteArrayInputStream in = new ByteArrayInputStream(exportBytes);){
            IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
    }

    @GetMapping(value={"/{modelId}/json"})
    @Authorize(action={"get"})
    public Object getEditorJson(@PathVariable String modelId) {
        JSONObject modelNode;
        Model model = this.repositoryService.getModel(modelId);
        if (model == null) {
            throw new NullPointerException("\u6a21\u578b\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((CharSequence)model.getMetaInfo())) {
            modelNode = JSON.parseObject((String)model.getMetaInfo());
        } else {
            modelNode = new JSONObject();
            modelNode.put(MODEL_NAME, (Object)model.getName());
        }
        modelNode.put(MODEL_ID, (Object)model.getId());
        modelNode.put("model", JSON.parse((String)new String(this.repositoryService.getModelEditorSource(model.getId()))));
        return modelNode;
    }

    @PutMapping(value={"/{modelId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Authorize(action={"update"})
    public void saveModel(@PathVariable String modelId, @RequestParam Map<String, String> values) throws TranscoderException, IOException {
        Model model = this.repositoryService.getModel(modelId);
        JSONObject modelJson = JSON.parseObject((String)model.getMetaInfo());
        modelJson.put(MODEL_NAME, (Object)values.get(MODEL_NAME));
        modelJson.put(MODEL_DESCRIPTION, (Object)values.get(MODEL_DESCRIPTION));
        model.setMetaInfo(modelJson.toString());
        model.setName(values.get(MODEL_NAME));
        this.repositoryService.saveModel(model);
        this.repositoryService.addModelEditorSource(model.getId(), values.get("json_xml").getBytes("utf-8"));
        ByteArrayInputStream svgStream = new ByteArrayInputStream(values.get("svg_xml").getBytes("utf-8"));
        TranscoderInput input = new TranscoderInput((InputStream)svgStream);
        PNGTranscoder transcoder = new PNGTranscoder();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        TranscoderOutput output = new TranscoderOutput((OutputStream)outStream);
        transcoder.transcode(input, output);
        byte[] result = outStream.toByteArray();
        this.repositoryService.addModelEditorSourceExtra(model.getId(), result);
        outStream.close();
    }

    @DeleteMapping(value={"/{modelId}"})
    @Authorize(action={"delete"})
    public ResponseMessage<Void> delete(@PathVariable String modelId) {
        this.repositoryService.deleteModel(modelId);
        return ResponseMessage.ok();
    }
}

