/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.dimension.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hswebframework.expands.script.engine.DynamicScriptEngine;
import org.hswebframework.expands.script.engine.DynamicScriptEngineFactory;
import org.hswebframework.web.Lists;
import org.hswebframework.web.Maps;
import org.hswebframework.web.entity.authorization.UserEntity;
import org.hswebframework.web.entity.organizational.PersonEntity;
import org.hswebframework.web.organizational.authorization.relation.PersonRelations;
import org.hswebframework.web.organizational.authorization.relation.Relation;
import org.hswebframework.web.organizational.authorization.relation.RelationsManager;
import org.hswebframework.web.workflow.dimension.DimensionContext;
import org.hswebframework.web.workflow.dimension.parser.CandidateDimensionParserStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

@ConditionalOnBean(value={RelationsManager.class})
public class ScriptCandiateDimensionParserStrategy
implements CandidateDimensionParserStrategy {
    private static final Logger log = LoggerFactory.getLogger(ScriptCandiateDimensionParserStrategy.class);
    @Autowired
    private RelationsManager relationsManager;

    @Override
    public boolean support(String dimension) {
        return "relation".equals(dimension);
    }

    @Override
    public List<String> parse(DimensionContext context, CandidateDimensionParserStrategy.StrategyConfig config) {
        String expression = config.getStringConfig("expression").orElse(null);
        String expressionLanguage = config.getStringConfig("expressionLanguage").orElse(null);
        if (StringUtils.isEmpty((Object)expression)) {
            return new ArrayList<String>();
        }
        String creatorId = context.getCreatorId();
        Supplier<PersonRelations> creator = () -> this.relationsManager.getPersonRelationsByUserId(creatorId);
        DynamicScriptEngine engine = DynamicScriptEngineFactory.getEngine((String)expressionLanguage);
        if (engine == null) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u811a\u672c:" + expressionLanguage);
        }
        String id = DigestUtils.md5DigestAsHex((byte[])expression.getBytes());
        if (!engine.compiled(id)) {
            engine.compile(id, expression);
        }
        Object obj = engine.execute(id, Maps.buildMap().put((Object)"user", creator).put((Object)"creator", creator).put((Object)"creatorId", (Object)creatorId).put((Object)"context", (Object)context).get()).getIfSuccess();
        Function<Object, String> userIdConverter = o -> {
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof Relation) {
                Serializable target = ((Relation)o).getTargetObject();
                if (target instanceof PersonEntity) {
                    return ((PersonEntity)target).getUserId();
                }
                if (target instanceof UserEntity) {
                    return (String)((UserEntity)target).getId();
                }
                return ((Relation)o).getTarget();
            }
            log.warn("\u4e0d\u652f\u6301\u7684\u5173\u7cfb:{}", o);
            return null;
        };
        if (obj instanceof List) {
            List list = (List)obj;
            return list.stream().map(userIdConverter).filter(Objects::nonNull).collect(Collectors.toList());
        }
        String result = userIdConverter.apply(obj);
        if (result == null) {
            return new ArrayList<String>();
        }
        return Lists.buildList((Object[])new String[]{result}).get();
    }
}

