/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.dimension.parser;

import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.web.commons.entity.Entity;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.service.authorization.UserService;
import org.hswebframework.web.workflow.dimension.DimensionContext;
import org.hswebframework.web.workflow.dimension.parser.CandidateDimensionParserStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(value={UserService.class})
public class DepartmentCandidateDimensionParserStrategy
implements CandidateDimensionParserStrategy {
    @Autowired(required=false)
    private UserService userService;

    @Override
    public boolean support(String dimension) {
        return "department".equals(dimension) && this.userService != null;
    }

    @Override
    public List<String> parse(DimensionContext context, CandidateDimensionParserStrategy.StrategyConfig config) {
        String type = config.getConfig("tree").map(String::valueOf).map("-"::concat).orElse("");
        return this.userService.select((Entity)QueryParamEntity.empty().noPaging().where("id", "user-in-department" + type, config.getIdList())).stream().map(GenericEntity::getId).collect(Collectors.toList());
    }
}

