/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.web.diagram;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.CallActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.ErrorEventDefinition;
import org.activiti.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.Lane;
import org.activiti.engine.impl.pvm.process.LaneSet;
import org.activiti.engine.impl.pvm.process.ParticipantProcess;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseProcessDefinitionDiagramLayoutResource {
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private HistoryService historyService;

    public Map<String, Object> getDiagramNode(String processInstanceId, String processDefinitionId) {
        List<Object> highLightedFlows = Collections.emptyList();
        HashMap<String, Object> subProcessInstanceMap = new HashMap<String, Object>();
        ProcessInstance processInstance = null;
        if (processInstanceId != null) {
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            if (processInstance == null) {
                throw new ActivitiObjectNotFoundException("Process instance could not be found");
            }
            processDefinitionId = processInstance.getProcessDefinitionId();
            List subProcessInstances = this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInstanceId).list();
            for (ProcessInstance subProcessInstance : subProcessInstances) {
                String subDefId = subProcessInstance.getProcessDefinitionId();
                String superExecutionId = subProcessInstance.getSuperExecutionId();
                ProcessDefinitionEntity subDef = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(subDefId);
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("processInstanceId", (Object)subProcessInstance.getId());
                jSONObject.put("superExecutionId", (Object)superExecutionId);
                jSONObject.put("processDefinitionId", (Object)subDef.getId());
                jSONObject.put("processDefinitionKey", (Object)subDef.getKey());
                jSONObject.put("processDefinitionName", (Object)subDef.getName());
                subProcessInstanceMap.put(superExecutionId, jSONObject);
            }
        }
        if (processDefinitionId == null) {
            throw new ActivitiObjectNotFoundException("No process definition id provided");
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(processDefinitionId);
        if (processDefinition == null) {
            throw new ActivitiException("Process definition " + processDefinitionId + " could not be found");
        }
        JSONObject responseJSON = new JSONObject();
        Map<String, Object> pdrJSON = this.getProcessDefinitionResponse(processDefinition);
        if (pdrJSON != null) {
            responseJSON.put("processDefinition", pdrJSON);
        }
        if (processInstance != null) {
            JSONArray activityArray = new JSONArray();
            JSONArray flowsArray = new JSONArray();
            List highLightedActivities = this.runtimeService.getActiveActivityIds(processInstanceId);
            highLightedFlows = this.getHighLightedFlows(processInstanceId, processDefinition);
            for (String string : highLightedActivities) {
                activityArray.add((Object)string);
            }
            for (String string : highLightedFlows) {
                flowsArray.add((Object)string);
            }
            responseJSON.put("highLightedActivities", (Object)activityArray);
            responseJSON.put("highLightedFlows", (Object)flowsArray);
        }
        if (processDefinition.getParticipantProcess() != null) {
            ParticipantProcess pProc = processDefinition.getParticipantProcess();
            JSONObject participantProcessJSON = new JSONObject();
            participantProcessJSON.put("id", (Object)pProc.getId());
            if (StringUtils.isNotEmpty((CharSequence)pProc.getName())) {
                participantProcessJSON.put("name", (Object)pProc.getName());
            } else {
                participantProcessJSON.put("name", (Object)"");
            }
            participantProcessJSON.put("x", (Object)pProc.getX());
            participantProcessJSON.put("y", (Object)pProc.getY());
            participantProcessJSON.put("width", (Object)pProc.getWidth());
            participantProcessJSON.put("height", (Object)pProc.getHeight());
            responseJSON.put("participantProcess", (Object)participantProcessJSON);
        }
        if (processDefinition.getLaneSets() != null && !processDefinition.getLaneSets().isEmpty()) {
            JSONArray laneSetArray = new JSONArray();
            for (LaneSet laneSet : processDefinition.getLaneSets()) {
                JSONArray jSONArray = new JSONArray();
                if (laneSet.getLanes() != null && !laneSet.getLanes().isEmpty()) {
                    for (Lane lane : laneSet.getLanes()) {
                        JSONObject laneJSON = new JSONObject();
                        laneJSON.put("id", (Object)lane.getId());
                        if (StringUtils.isNotEmpty((CharSequence)lane.getName())) {
                            laneJSON.put("name", (Object)lane.getName());
                        } else {
                            laneJSON.put("name", (Object)"");
                        }
                        laneJSON.put("x", (Object)lane.getX());
                        laneJSON.put("y", (Object)lane.getY());
                        laneJSON.put("width", (Object)lane.getWidth());
                        laneJSON.put("height", (Object)lane.getHeight());
                        List flowNodeIds = lane.getFlowNodeIds();
                        JSONArray flowNodeIdsArray = new JSONArray();
                        for (String flowNodeId : flowNodeIds) {
                            flowNodeIdsArray.add((Object)flowNodeId);
                        }
                        laneJSON.put("flowNodeIds", (Object)flowNodeIdsArray);
                        jSONArray.add((Object)laneJSON);
                    }
                }
                JSONObject laneSetJSON = new JSONObject();
                laneSetJSON.put("id", (Object)laneSet.getId());
                if (StringUtils.isNotEmpty((CharSequence)laneSet.getName())) {
                    laneSetJSON.put("name", (Object)laneSet.getName());
                } else {
                    laneSetJSON.put("name", (Object)"");
                }
                laneSetJSON.put("lanes", (Object)jSONArray);
                laneSetArray.add((Object)laneSetJSON);
            }
            if (laneSetArray.size() > 0) {
                responseJSON.put("laneSets", (Object)laneSetArray);
            }
        }
        JSONArray sequenceFlowArray = new JSONArray();
        JSONArray activityArray = new JSONArray();
        for (ActivityImpl activityImpl : processDefinition.getActivities()) {
            this.getActivity(processInstanceId, activityImpl, (List<Object>)activityArray, (List<Object>)sequenceFlowArray, processInstance, highLightedFlows, subProcessInstanceMap);
        }
        responseJSON.put("activities", (Object)activityArray);
        responseJSON.put("sequenceFlows", (Object)sequenceFlowArray);
        return responseJSON;
    }

    private List<String> getHighLightedFlows(String processInstanceId, ProcessDefinitionEntity processDefinition) {
        ArrayList<String> highLightedFlows = new ArrayList<String>();
        List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceStartTime().asc()).list();
        ArrayList<String> historicActivityInstanceList = new ArrayList<String>();
        for (HistoricActivityInstance hai : historicActivityInstances) {
            historicActivityInstanceList.add(hai.getActivityId());
        }
        List highLightedActivities = this.runtimeService.getActiveActivityIds(processInstanceId);
        historicActivityInstanceList.addAll(highLightedActivities);
        for (ActivityImpl activity : processDefinition.getActivities()) {
            int index = historicActivityInstanceList.indexOf(activity.getId());
            if (index < 0 || index + 1 >= historicActivityInstanceList.size()) continue;
            List pvmTransitionList = activity.getOutgoingTransitions();
            for (PvmTransition pvmTransition : pvmTransitionList) {
                String destinationFlowId = pvmTransition.getDestination().getId();
                if (!destinationFlowId.equals(historicActivityInstanceList.get(index + 1))) continue;
                highLightedFlows.add(pvmTransition.getId());
            }
        }
        return highLightedFlows;
    }

    private void getActivity(String processInstanceId, ActivityImpl activity, List<Object> activityArray, List<Object> sequenceFlowArray, ProcessInstance processInstance, List<String> highLightedFlows, Map<String, Object> subProcessInstanceMap) {
        JSONObject activityJSON = new JSONObject();
        String multiInstance = (String)activity.getProperty("multiInstance");
        if (multiInstance != null && !"sequential".equals(multiInstance)) {
            multiInstance = "parallel";
        }
        ActivityBehavior activityBehavior = activity.getActivityBehavior();
        Boolean collapsed = activityBehavior instanceof CallActivityBehavior;
        Boolean expanded = (Boolean)activity.getProperty("isExpanded");
        if (expanded != null) {
            collapsed = expanded == false;
        }
        Boolean isInterrupting = null;
        if (activityBehavior instanceof BoundaryEventActivityBehavior) {
            isInterrupting = ((BoundaryEventActivityBehavior)activityBehavior).isInterrupting();
        }
        for (Object sequenceFlow : activity.getOutgoingTransitions()) {
            String flowName = (String)sequenceFlow.getProperty("name");
            boolean isHighLighted = highLightedFlows.contains(sequenceFlow.getId());
            boolean isConditional = sequenceFlow.getProperty("condition") != null && !((String)activity.getProperty("type")).toLowerCase().contains("gateway");
            boolean isDefault = sequenceFlow.getId().equals(activity.getProperty("default")) && ((String)activity.getProperty("type")).toLowerCase().contains("gateway");
            List waypoints = ((TransitionImpl)sequenceFlow).getWaypoints();
            JSONArray xPointArray = new JSONArray();
            JSONArray yPointArray = new JSONArray();
            for (int i = 0; i < waypoints.size(); i += 2) {
                xPointArray.add(waypoints.get(i));
                yPointArray.add(waypoints.get(i + 1));
            }
            JSONObject flowJSON = new JSONObject();
            flowJSON.put("id", (Object)sequenceFlow.getId());
            flowJSON.put("name", (Object)flowName);
            flowJSON.put("flow", (Object)("(" + sequenceFlow.getSource().getId() + ")--" + sequenceFlow.getId() + "-->(" + sequenceFlow.getDestination().getId() + ")"));
            if (isConditional) {
                flowJSON.put("isConditional", (Object)isConditional);
            }
            if (isDefault) {
                flowJSON.put("isDefault", (Object)isDefault);
            }
            if (isHighLighted) {
                flowJSON.put("isHighLighted", (Object)isHighLighted);
            }
            flowJSON.put("xPointArray", (Object)xPointArray);
            flowJSON.put("yPointArray", (Object)yPointArray);
            sequenceFlowArray.add(flowJSON);
        }
        JSONArray nestedActivityArray = new JSONArray();
        for (ActivityImpl nestedActivity : activity.getActivities()) {
            nestedActivityArray.add((Object)nestedActivity.getId());
        }
        Map properties = activity.getProperties();
        JSONObject propertiesJSON = new JSONObject();
        for (String key : properties.keySet()) {
            Object prop = properties.get(key);
            if (prop instanceof String) {
                propertiesJSON.put(key, properties.get(key));
                continue;
            }
            if (prop instanceof Integer) {
                propertiesJSON.put(key, properties.get(key));
                continue;
            }
            if (prop instanceof Boolean) {
                propertiesJSON.put(key, properties.get(key));
                continue;
            }
            if ("initial".equals(key)) {
                ActivityImpl act = (ActivityImpl)properties.get(key);
                propertiesJSON.put(key, (Object)act.getId());
                continue;
            }
            if ("timerDeclarations".equals(key)) {
                ArrayList timerDeclarations = (ArrayList)properties.get(key);
                JSONArray timerDeclarationArray = new JSONArray();
                if (timerDeclarations != null) {
                    for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                        JSONObject timerDeclarationJSON = new JSONObject();
                        timerDeclarationJSON.put("isExclusive", (Object)timerDeclaration.isExclusive());
                        if (timerDeclaration.getRepeat() != null) {
                            timerDeclarationJSON.put("repeat", (Object)timerDeclaration.getRepeat());
                        }
                        timerDeclarationJSON.put("retries", (Object)String.valueOf(timerDeclaration.getRetries()));
                        timerDeclarationJSON.put("type", (Object)timerDeclaration.getJobHandlerType());
                        timerDeclarationJSON.put("configuration", (Object)timerDeclaration.getJobHandlerConfiguration());
                        timerDeclarationArray.add((Object)timerDeclarationJSON);
                    }
                }
                if (timerDeclarationArray.size() <= 0) continue;
                propertiesJSON.put(key, (Object)timerDeclarationArray);
                continue;
            }
            if ("eventDefinitions".equals(key)) {
                ArrayList eventDefinitions = (ArrayList)properties.get(key);
                JSONArray eventDefinitionsArray = new JSONArray();
                if (eventDefinitions != null) {
                    for (EventSubscriptionDeclaration eventDefinition : eventDefinitions) {
                        JSONObject eventDefinitionJSON = new JSONObject();
                        if (eventDefinition.getActivityId() != null) {
                            eventDefinitionJSON.put("activityId", (Object)eventDefinition.getActivityId());
                        }
                        eventDefinitionJSON.put("eventName", (Object)eventDefinition.getEventName());
                        eventDefinitionJSON.put("eventType", (Object)eventDefinition.getEventType());
                        eventDefinitionJSON.put("isAsync", (Object)eventDefinition.isAsync());
                        eventDefinitionJSON.put("isStartEvent", (Object)eventDefinition.isStartEvent());
                        eventDefinitionsArray.add((Object)eventDefinitionJSON);
                    }
                }
                if (eventDefinitionsArray.size() <= 0) continue;
                propertiesJSON.put(key, (Object)eventDefinitionsArray);
                continue;
            }
            if (!"errorEventDefinitions".equals(key)) continue;
            ArrayList errorEventDefinitions = (ArrayList)properties.get(key);
            JSONArray errorEventDefinitionsArray = new JSONArray();
            if (errorEventDefinitions != null) {
                Iterator iterator = errorEventDefinitions.iterator();
                while (iterator.hasNext()) {
                    ErrorEventDefinition errorEventDefinition = (ErrorEventDefinition)iterator.next();
                    JSONObject errorEventDefinitionJSON = new JSONObject();
                    if (errorEventDefinition.getErrorCode() != null) {
                        errorEventDefinitionJSON.put("errorCode", (Object)errorEventDefinition.getErrorCode());
                    } else {
                        errorEventDefinitionJSON.put("errorCode", null);
                    }
                    errorEventDefinitionJSON.put("handlerActivityId", (Object)errorEventDefinition.getHandlerActivityId());
                    errorEventDefinitionsArray.add((Object)errorEventDefinitionJSON);
                }
            }
            if (errorEventDefinitionsArray.size() <= 0) continue;
            propertiesJSON.put(key, (Object)errorEventDefinitionsArray);
        }
        if ("callActivity".equals(properties.get("type"))) {
            CallActivityBehavior callActivityBehavior = null;
            if (activityBehavior instanceof CallActivityBehavior) {
                callActivityBehavior = (CallActivityBehavior)activityBehavior;
            }
            if (callActivityBehavior != null) {
                ProcessDefinition lastProcessDefinition;
                List executionList;
                propertiesJSON.put("processDefinitonKey", (Object)callActivityBehavior.getProcessDefinitonKey());
                JSONArray processInstanceArray = new JSONArray();
                if (processInstance != null && !(executionList = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).activityId(activity.getId()).list()).isEmpty()) {
                    for (Execution execution : executionList) {
                        processInstanceArray.add(subProcessInstanceMap.get(execution.getId()));
                    }
                }
                if (processInstanceArray.size() == 0 && StringUtils.isNotEmpty((CharSequence)callActivityBehavior.getProcessDefinitonKey()) && (lastProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(callActivityBehavior.getProcessDefinitonKey()).latestVersion().singleResult()) != null) {
                    JSONObject processInstanceJSON = new JSONObject();
                    processInstanceJSON.put("processDefinitionId", (Object)lastProcessDefinition.getId());
                    processInstanceJSON.put("processDefinitionKey", (Object)lastProcessDefinition.getKey());
                    processInstanceJSON.put("processDefinitionName", (Object)lastProcessDefinition.getName());
                    processInstanceArray.add((Object)processInstanceJSON);
                }
                if (processInstanceArray.size() > 0) {
                    propertiesJSON.put("processDefinitons", (Object)processInstanceArray);
                }
            }
        }
        activityJSON.put("activityId", (Object)activity.getId());
        activityJSON.put("properties", (Object)propertiesJSON);
        if (multiInstance != null) {
            activityJSON.put("multiInstance", (Object)multiInstance);
        }
        if (collapsed.booleanValue()) {
            activityJSON.put("collapsed", (Object)collapsed);
        }
        if (nestedActivityArray.size() > 0) {
            activityJSON.put("nestedActivities", (Object)nestedActivityArray);
        }
        if (isInterrupting != null) {
            activityJSON.put("isInterrupting", (Object)isInterrupting);
        }
        activityJSON.put("x", (Object)activity.getX());
        activityJSON.put("y", (Object)activity.getY());
        activityJSON.put("width", (Object)activity.getWidth());
        activityJSON.put("height", (Object)activity.getHeight());
        activityArray.add(activityJSON);
        for (ActivityImpl nestedActivity : activity.getActivities()) {
            this.getActivity(processInstanceId, nestedActivity, activityArray, sequenceFlowArray, processInstance, highLightedFlows, subProcessInstanceMap);
        }
    }

    private Map<String, Object> getProcessDefinitionResponse(ProcessDefinitionEntity processDefinition) {
        JSONObject pdrJSON = new JSONObject();
        pdrJSON.put("id", (Object)processDefinition.getId());
        pdrJSON.put("name", (Object)processDefinition.getName());
        pdrJSON.put("key", (Object)processDefinition.getKey());
        pdrJSON.put("version", (Object)processDefinition.getVersion());
        pdrJSON.put("deploymentId", (Object)processDefinition.getDeploymentId());
        pdrJSON.put("isGraphicNotationDefined", (Object)this.isGraphicNotationDefined(processDefinition));
        return pdrJSON;
    }

    private boolean isGraphicNotationDefined(ProcessDefinitionEntity processDefinition) {
        return ((ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(processDefinition.getId())).isGraphicalNotationDefined();
    }
}

