/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.apache.commons.io.FilenameUtils;
import org.hswebframework.web.NotFoundException;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.commons.entity.PagerResult;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.workflow.service.BpmActivityService;
import org.hswebframework.web.workflow.service.BpmProcessService;
import org.hswebframework.web.workflow.service.BpmTaskService;
import org.hswebframework.web.workflow.service.imp.AbstractFlowableService;
import org.hswebframework.web.workflow.util.QueryUtils;
import org.hswebframework.web.workflow.web.response.ActivityInfo;
import org.hswebframework.web.workflow.web.response.ProcessDefinitionInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/workflow/process/definition"})
@Api(tags={"\u5de5\u4f5c\u6d41-\u6d41\u7a0b\u5b9a\u4e49\u7ba1\u7406"}, description="\u5de5\u4f5c\u6d41\u6d41\u7a0b\u5b9a\u4e49\u7ba1\u7406")
@Authorize(permission={"workflow-definition"}, description={"\u5de5\u4f5c\u6d41-\u6d41\u7a0b\u5b9a\u4e49\u7ba1\u7406"})
public class FlowableDeploymentController
extends AbstractFlowableService {
    private static final String MODEL_ID = "modelId";
    @Autowired
    BpmTaskService bpmTaskService;
    @Autowired
    BpmProcessService bpmProcessService;
    @Autowired
    BpmActivityService bpmActivityService;

    @GetMapping
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868")
    @Authorize(action={"query"})
    public ResponseMessage<PagerResult<ProcessDefinitionInfo>> queryProcessList(QueryParamEntity param) {
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        return ResponseMessage.ok(QueryUtils.doQuery(processDefinitionQuery, param, ProcessDefinitionInfo::of));
    }

    @PostMapping(value={"/deploy"})
    @ApiOperation(value="\u4e0a\u4f20\u6d41\u7a0b\u5b9a\u4e49\u6587\u4ef6\u5e76\u90e8\u7f72\u6d41\u7a0b")
    @Authorize(action={"deploy"})
    public ResponseMessage<Deployment> deploy(@RequestPart(value="file") MultipartFile file) throws IOException {
        String fileName = file.getOriginalFilename();
        InputStream fileInputStream = file.getInputStream();
        String extension = FilenameUtils.getExtension((String)fileName);
        DeploymentBuilder deployment = this.repositoryService.createDeployment();
        if ("zip".equals(extension) || "bar".equals(extension)) {
            ZipInputStream zip = new ZipInputStream(fileInputStream);
            deployment.addZipInputStream(zip);
        } else {
            deployment.addInputStream(fileName, fileInputStream);
        }
        Deployment result = deployment.deploy();
        return ResponseMessage.ok((Object)result);
    }

    @GetMapping(value={"/{processDefinitionId}/resource/{resourceName}"})
    @ApiOperation(value="\u8bfb\u53d6\u6d41\u7a0b\u8d44\u6e90")
    @Authorize(action={"query"})
    public void readResource(@PathVariable String processDefinitionId, @PathVariable String resourceName, HttpServletResponse response) {
        ProcessDefinitionQuery pdq = this.repositoryService.createProcessDefinitionQuery();
        ProcessDefinition pd = (ProcessDefinition)pdq.processDefinitionId(processDefinitionId).singleResult();
        try (InputStream resourceAsStream = this.repositoryService.getResourceAsStream(pd.getDeploymentId(), resourceName);){
            StreamUtils.copy((InputStream)resourceAsStream, (OutputStream)response.getOutputStream());
        }
    }

    @PutMapping(value={"/convert-to-model/{processDefinitionId}"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49\u8f6c\u6362\u6a21\u578b")
    @Authorize(action={"update"})
    public ResponseMessage<String> convertToModel(@PathVariable(value="processDefinitionId") String processDefinitionId) throws UnsupportedEncodingException, XMLStreamException {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        if (null == processDefinition) {
            throw new NotFoundException();
        }
        InputStream bpmnStream = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), processDefinition.getResourceName());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        InputStreamReader in = new InputStreamReader(bpmnStream, "UTF-8");
        XMLStreamReader xtr = xif.createXMLStreamReader(in);
        BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
        BpmnJsonConverter converter = new BpmnJsonConverter();
        ObjectNode modelNode = converter.convertToJson(bpmnModel);
        Model modelData = this.repositoryService.newModel();
        modelData.setKey(processDefinition.getKey());
        modelData.setName(processDefinition.getResourceName().substring(0, processDefinition.getResourceName().indexOf(".")));
        modelData.setCategory(processDefinition.getDeploymentId());
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", processDefinition.getName());
        modelObjectNode.put("revision", 1);
        modelObjectNode.put("description", processDefinition.getDescription());
        modelData.setMetaInfo(modelObjectNode.toString());
        this.repositoryService.saveModel(modelData);
        this.repositoryService.addModelEditorSource(modelData.getId(), modelNode.toString().getBytes("utf-8"));
        return ResponseMessage.ok((Object)modelData.getId());
    }

    @DeleteMapping(value={"/deployment/{deploymentId}"})
    @ApiOperation(value="\u5220\u9664\u90e8\u7f72\u7684\u6d41\u7a0b")
    @Authorize(action={"delete"})
    public ResponseMessage<Void> deleteProcessDefinition(@PathVariable(value="deploymentId") String deploymentId, @RequestParam(defaultValue="false") boolean cascade) {
        this.repositoryService.deleteDeployment(deploymentId, cascade);
        return ResponseMessage.ok();
    }

    @GetMapping(value={"/{processInstanceId}/activity"})
    @ApiOperation(value="\u67e5\u770b\u5f53\u524d\u6d41\u7a0b\u6d3b\u52a8\u8282\u70b9\u6d41\u7a0b\u56fe")
    @Authorize(action={"query"})
    public ResponseMessage<ActivityInfo> getProcessInstanceActivity(@PathVariable String processInstanceId) {
        HistoricProcessInstance processInstance = this.bpmTaskService.selectHisProInst(processInstanceId);
        if (processInstance != null) {
            ActivityImpl activity = this.bpmActivityService.getActivityByProcInstId(processInstance.getProcessDefinitionId(), processInstance.getId());
            return ResponseMessage.ok((Object)ActivityInfo.of(activity));
        }
        throw new NotFoundException("\u6d41\u7a0b\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"/{processInstanceId}/image"})
    @ApiOperation(value="\u67e5\u770b\u5f53\u524d\u6d41\u7a0b\u6d3b\u52a8\u8282\u70b9\u6d41\u7a0b\u56fe")
    @Authorize(action={"query"})
    public void getProcessImage(@PathVariable String processInstanceId, HttpServletResponse response) throws IOException {
        try (InputStream inputStream = this.bpmProcessService.findProcessPic(processInstanceId);){
            response.setContentType("image/png");
            ImageIO.write((RenderedImage)ImageIO.read(inputStream), "png", (OutputStream)response.getOutputStream());
        }
    }
}

