/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.service.imp;

import io.vavr.Lazy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.expands.script.engine.DynamicScriptEngine;
import org.hswebframework.expands.script.engine.DynamicScriptEngineFactory;
import org.hswebframework.expands.script.engine.ExecuteResult;
import org.hswebframework.web.BusinessException;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationHolder;
import org.hswebframework.web.authorization.AuthenticationPredicate;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.organizational.authorization.PersonnelAuthentication;
import org.hswebframework.web.organizational.authorization.PersonnelAuthenticationHolder;
import org.hswebframework.web.workflow.dao.entity.ActivityConfigEntity;
import org.hswebframework.web.workflow.dao.entity.ListenerConfig;
import org.hswebframework.web.workflow.dao.entity.ProcessDefineConfigEntity;
import org.hswebframework.web.workflow.dimension.CandidateDimension;
import org.hswebframework.web.workflow.dimension.CandidateDimensionParser;
import org.hswebframework.web.workflow.dimension.DimensionContext;
import org.hswebframework.web.workflow.dimension.PermissionDimensionParser;
import org.hswebframework.web.workflow.listener.ProcessEventListener;
import org.hswebframework.web.workflow.listener.TaskEventListener;
import org.hswebframework.web.workflow.service.ActivityConfigService;
import org.hswebframework.web.workflow.service.ProcessDefineConfigService;
import org.hswebframework.web.workflow.service.config.ActivityConfiguration;
import org.hswebframework.web.workflow.service.config.CandidateInfo;
import org.hswebframework.web.workflow.service.config.ProcessConfiguration;
import org.hswebframework.web.workflow.service.config.ProcessConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ProcessConfigurationServiceImpl
implements ProcessConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(ProcessConfigurationServiceImpl.class);
    @Autowired
    private ProcessDefineConfigService defineConfigService;
    @Autowired
    private ActivityConfigService activityConfigService;
    @Autowired
    private PermissionDimensionParser permissionDimensionParser;
    @Autowired
    private CandidateDimensionParser candidateDimensionParser;
    private static final EmptyActivityConfiguration emptyConfiguration = new EmptyActivityConfiguration();

    @Override
    public ActivityConfiguration getActivityConfiguration(final String doingUser, final String processDefineId, final String activityId) {
        final ActivityConfigEntity configEntity = this.activityConfigService.selectByProcessDefineIdAndActivityId(processDefineId, activityId);
        if (configEntity == null) {
            return emptyConfiguration;
        }
        return new ActivityConfiguration(){

            @Override
            public String getFormId() {
                return configEntity.getFormId();
            }

            @Override
            public boolean canClaim(Task task, String userId) {
                return this.getCandidateInfo(task).stream().map(CandidateInfo::user).anyMatch(user -> user.getUser().getId().equals(userId));
            }

            @Override
            public List<CandidateInfo> getCandidateInfo(Task task) {
                return (List)Lazy.val(() -> {
                    DimensionContext context = new DimensionContext();
                    context.setCreatorId(doingUser);
                    context.setActivityId(activityId);
                    context.setProcessDefineId(processDefineId);
                    context.setTask((TaskInfo)task);
                    CandidateDimension dimension = ProcessConfigurationServiceImpl.this.candidateDimensionParser.parse(context, configEntity.getCandidateDimension());
                    return dimension.getCandidateUserIdList().stream().distinct().map(userId -> (CandidateInfo)Lazy.val(() -> new CandidateInfo((String)userId){
                        final /* synthetic */ String val$userId;
                        {
                            this.val$userId = string;
                        }

                        @Override
                        public Authentication user() {
                            return AuthenticationHolder.get((String)this.val$userId);
                        }

                        @Override
                        public PersonnelAuthentication person() {
                            return PersonnelAuthenticationHolder.getByUserId((String)this.val$userId);
                        }
                    }, CandidateInfo.class)).collect(Collectors.toList());
                }, List.class);
            }

            @Override
            public TaskEventListener getTaskListener(String eventType) {
                if (CollectionUtils.isEmpty(configEntity.getListeners())) {
                    return null;
                }
                return configEntity.getListeners().stream().filter(config -> eventType.equals(config.getEventType())).map(ProcessConfigurationServiceImpl.this::createTaskEventListener).collect(Collectors.collectingAndThen(Collectors.toList(), list -> event -> list.forEach(listener -> listener.accept(event))));
            }
        };
    }

    protected <T> Consumer<T> createTaskEventListener(ListenerConfig listenerConfig) {
        DynamicScriptEngine engine = DynamicScriptEngineFactory.getEngine((String)listenerConfig.getLanguage());
        if (null != engine) {
            String scriptId = DigestUtils.md5Hex((String)listenerConfig.getScript());
            if (!engine.compiled(scriptId)) {
                engine.compile(scriptId, listenerConfig.getScript());
            }
            return event -> {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("event", event);
                ExecuteResult result = engine.execute(scriptId, context);
                if (!result.isSuccess()) {
                    throw new BusinessException("\u6267\u884c\u76d1\u542c\u5668\u5931\u8d25:" + result.getMessage(), (Throwable)result.getException());
                }
            };
        }
        log.warn("\u4e0d\u652f\u6301\u7684\u811a\u672c\u8bed\u8a00:{}", (Object)listenerConfig.getLanguage());
        return null;
    }

    @Override
    public ProcessConfiguration getProcessConfiguration(String processDefineId) {
        final ProcessDefineConfigEntity entity = this.defineConfigService.selectByProcessDefineId(processDefineId);
        if (entity == null) {
            return emptyConfiguration;
        }
        return new ProcessConfiguration(){

            @Override
            public String getFormId() {
                return entity.getFormId();
            }

            @Override
            public void assertCanStartProcess(String userId, ProcessDefinition definition) {
                if (!this.canStartProcess(userId, definition)) {
                    throw new AccessDenyException("\u6ca1\u6709\u6743\u9650\u542f\u52a8\u6b64\u6d41\u7a0b");
                }
            }

            @Override
            public boolean canStartProcess(String userId, ProcessDefinition definition) {
                if (StringUtils.isEmpty((Object)entity.getPermissionDimension()) || "*".equals(entity.getPermissionDimension())) {
                    return true;
                }
                AuthenticationPredicate predicate = ProcessConfigurationServiceImpl.this.permissionDimensionParser.parse(entity.getPermissionDimension());
                if (null != predicate) {
                    return predicate.test((Object)AuthenticationHolder.get((String)userId));
                }
                return true;
            }

            @Override
            public ProcessEventListener getProcessListener(String eventType) {
                if (CollectionUtils.isEmpty(entity.getListeners())) {
                    return null;
                }
                return entity.getListeners().stream().filter(config -> eventType.equals(config.getEventType())).map(ProcessConfigurationServiceImpl.this::createTaskEventListener).collect(Collectors.collectingAndThen(Collectors.toList(), list -> event -> list.forEach(listener -> listener.accept(event))));
            }
        };
    }

    private static final class EmptyActivityConfiguration
    implements ActivityConfiguration,
    ProcessConfiguration {
        private EmptyActivityConfiguration() {
        }

        @Override
        public String getFormId() {
            return null;
        }

        @Override
        public boolean canClaim(Task task, String userId) {
            return false;
        }

        @Override
        public List<CandidateInfo> getCandidateInfo(Task task) {
            return new ArrayList<CandidateInfo>();
        }

        @Override
        public void assertCanStartProcess(String userId, ProcessDefinition definition) {
        }

        @Override
        public boolean canStartProcess(String userId, ProcessDefinition definition) {
            return true;
        }

        @Override
        public ProcessEventListener getProcessListener(String eventType) {
            return null;
        }

        @Override
        public TaskEventListener getTaskListener(String eventType) {
            return null;
        }
    }
}

