/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.service.imp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.TaskServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.BusinessException;
import org.hswebframework.web.NotFoundException;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.commons.entity.PagerResult;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.workflow.dao.entity.ProcessHistoryEntity;
import org.hswebframework.web.workflow.flowable.utils.JumpTaskCmd;
import org.hswebframework.web.workflow.service.BpmActivityService;
import org.hswebframework.web.workflow.service.BpmTaskService;
import org.hswebframework.web.workflow.service.ProcessHistoryService;
import org.hswebframework.web.workflow.service.WorkFlowFormService;
import org.hswebframework.web.workflow.service.config.CandidateInfo;
import org.hswebframework.web.workflow.service.config.ProcessConfigurationService;
import org.hswebframework.web.workflow.service.imp.AbstractFlowableService;
import org.hswebframework.web.workflow.service.request.CompleteTaskRequest;
import org.hswebframework.web.workflow.service.request.JumpTaskRequest;
import org.hswebframework.web.workflow.service.request.RejectTaskRequest;
import org.hswebframework.web.workflow.service.request.SaveFormRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(rollbackFor={Throwable.class})
public class BpmTaskServiceImpl
extends AbstractFlowableService
implements BpmTaskService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BpmActivityService bpmActivityService;
    @Autowired
    private ProcessConfigurationService processConfigurationService;
    @Autowired
    private WorkFlowFormService workFlowFormService;
    @Autowired
    private ProcessHistoryService processHistoryService;
    @Autowired
    private SqlExecutor sqlExecutor;

    @Override
    public List<Task> selectNowTask(String procInstId) {
        return ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procInstId)).active().list();
    }

    @Override
    public List<Task> selectTaskByProcessId(String procInstId) {
        return ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procInstId)).active().list();
    }

    @Override
    public Task selectTaskByTaskId(String taskId) {
        return (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).active().singleResult();
    }

    @Override
    public void claim(String taskId, String userId) {
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).taskCandidateUser(userId)).active().singleResult();
        if (task == null) {
            throw new NotFoundException("\u65e0\u6cd5\u7b7e\u6536\u6b64\u4efb\u52a1");
        }
        if (!StringUtils.isNullOrEmpty((Object)task.getAssignee())) {
            throw new BusinessException("\u4efb\u52a1\u5df2\u7b7e\u552e");
        }
        this.taskService.claim(taskId, userId);
    }

    @Override
    public void complete(CompleteTaskRequest request) {
        request.tryValidate(new Class[0]);
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(request.getTaskId())).includeProcessVariables()).active().singleResult();
        Objects.requireNonNull(task, "\u4efb\u52a1\u4e0d\u5b58\u5728");
        String assignee = task.getAssignee();
        Objects.requireNonNull(assignee, "\u4efb\u52a1\u672a\u7b7e\u6536");
        if (!assignee.equals(request.getCompleteUserId())) {
            throw new BusinessException("\u53ea\u80fd\u5b8c\u6210\u81ea\u5df1\u7684\u4efb\u52a1");
        }
        HashMap<String, Object> variable = new HashMap<String, Object>();
        variable.put("preTaskId", task.getId());
        HashMap<String, Object> transientVariables = new HashMap<String, Object>();
        if (null != request.getVariables()) {
            variable.putAll(request.getVariables());
            transientVariables.putAll(request.getVariables());
        }
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        Optional.of(this.workFlowFormService.selectProcessForm(instance.getProcessDefinitionId(), (QueryParamEntity)QueryParamEntity.of((String)"processInstanceId", (Object)instance.getProcessInstanceId()).doPaging(0, 2))).map(PagerResult::getData).map(list -> {
            if (list.size() == 1) {
                return (Map)list.get(0);
            }
            if (list.size() > 1) {
                this.logger.warn("\u4e3b\u8868\u6570\u636e\u5b58\u5728\u591a\u6761\u6570\u636e:processInstanceId={}", (Object)instance.getProcessInstanceId());
            }
            return null;
        }).ifPresent(transientVariables::putAll);
        this.workFlowFormService.saveTaskForm(instance, task, SaveFormRequest.builder().userName(request.getCompleteUserName()).userId(request.getCompleteUserId()).formData(request.getFormData()).build());
        if (null != request.getFormData()) {
            transientVariables.putAll(request.getFormData());
        }
        this.taskService.complete(task.getId(), null, transientVariables);
        if (!StringUtils.isNullOrEmpty((Object)request.getNextActivityId())) {
            this.doJumpTask(task, request.getNextActivityId(), t -> {});
        }
        List<Task> tasks = this.selectNowTask(task.getProcessInstanceId());
        for (Task next : tasks) {
            this.setVariablesLocal(next.getId(), variable);
            if (!StringUtils.isNullOrEmpty((Object)request.getNextClaimUserId())) {
                this.taskService.addCandidateUser(next.getId(), request.getNextClaimUserId());
                continue;
            }
            this.setCandidate(request.getCompleteUserId(), next);
        }
        ProcessHistoryEntity history = ProcessHistoryEntity.builder().businessKey(instance.getBusinessKey()).type("complete").typeText("\u5b8c\u6210\u4efb\u52a1").creatorId(request.getCompleteUserId()).creatorName(request.getCompleteUserName()).processDefineId(instance.getProcessDefinitionId()).processInstanceId(instance.getProcessInstanceId()).taskId(task.getId()).taskDefineKey(task.getTaskDefinitionKey()).taskName(task.getName()).build();
        this.processHistoryService.insert((Object)history);
    }

    @Override
    public void reject(RejectTaskRequest request) {
        request.tryValidate(new Class[0]);
        String taskId = request.getTaskId();
        Task curTask = this.selectTaskByTaskId(taskId);
        if (curTask == null) {
            throw new NotFoundException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u672a\u6fc0\u6d3b");
        }
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(curTask.getProcessInstanceId()).singleResult();
        ProcessDefinitionEntity entity = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(curTask.getProcessDefinitionId());
        ActivityImpl currActivity = entity.findActivity(curTask.getTaskDefinitionKey());
        ArrayList transitions = new ArrayList();
        this.findActivity((PvmActivity)currActivity, activity -> activity.getIncomingTransitions().stream().map(PvmTransition::getSource).collect(Collectors.toList()), activity -> transitions.isEmpty() && "userTask".equals(activity.getProperty("type")), transitions::add);
        if (transitions.isEmpty()) {
            throw new BusinessException("\u65e0\u6cd5\u83b7\u53d6\u4e0a\u4e00\u6b65\u4efb\u52a1");
        }
        PvmActivity transition = (PvmActivity)transitions.get(transitions.size() - 1);
        this.doJumpTask(curTask, transition.getId(), newTask -> {});
        ProcessHistoryEntity history = ProcessHistoryEntity.builder().businessKey(processInstance.getBusinessKey()).type("reject").typeText("\u9a73\u56de").creatorId(request.getRejectUserId()).creatorName(request.getRejectUserName()).processDefineId(processInstance.getProcessDefinitionId()).processInstanceId(processInstance.getProcessInstanceId()).taskId(taskId).taskDefineKey(curTask.getTaskDefinitionKey()).taskName(curTask.getName()).data(request.getData()).build();
        this.processHistoryService.insert((Object)history);
    }

    protected void findActivity(PvmActivity activity, Function<PvmActivity, List<PvmActivity>> function, Predicate<PvmActivity> predicate, Consumer<PvmActivity> consumer) {
        List<PvmActivity> activities = function.apply(activity);
        for (PvmActivity pvmActivity : activities) {
            consumer.accept(pvmActivity);
            if (predicate.test(pvmActivity)) {
                return;
            }
            this.findActivity(pvmActivity, function, predicate, consumer);
        }
    }

    public void doJumpTask(Task task, String activityId, Consumer<Task> newTaskConsumer) {
        ProcessDefinitionEntity entity = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        String sourceId = task.getTaskDefinitionKey();
        ActivityImpl targetActivity = entity.findActivity(activityId);
        ActivityImpl sourceActivity = entity.findActivity(sourceId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u6d41\u7a0b[{}({})]\u8df3\u8f6c[{}]->[{}]", new Object[]{entity.getName(), entity.getId(), sourceActivity.getId(), targetActivity.getId()});
        }
        ArrayList backActivities = new ArrayList();
        this.findActivity((PvmActivity)targetActivity, activity -> activity.getOutgoingTransitions().stream().map(PvmTransition::getDestination).collect(Collectors.toList()), activity -> sourceActivity.getId().equals(activity.getId()), backActivities::add);
        if (!backActivities.isEmpty()) {
            for (PvmActivity pvmTransition : backActivities) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u6d41\u7a0b[{}({})]\u56de\u9000[{}]->[{}],\u5220\u9664\u94fe\u63a5\u7ebf:{}", new Object[]{entity.getName(), entity.getId(), sourceActivity.getId(), targetActivity.getId(), pvmTransition.getId()});
                }
                List instance = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).activityId(pvmTransition.getId()).list();
                for (HistoricActivityInstance historicActivityInstance : instance) {
                    this.sqlExecutor.delete("delete from act_hi_actinst where id_= #{id}", (Object)historicActivityInstance);
                }
            }
        }
        TaskServiceImpl taskServiceImpl = (TaskServiceImpl)this.taskService;
        taskServiceImpl.getCommandExecutor().execute((Command)new JumpTaskCmd(task.getExecutionId(), activityId));
        this.selectNowTask(task.getProcessInstanceId()).forEach(t -> {
            this.setCandidate(task.getAssignee(), (Task)t);
            newTaskConsumer.accept((Task)t);
        });
    }

    @Override
    public void jumpTask(JumpTaskRequest request) {
        request.tryValidate(new Class[0]);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(request.getTaskId())).singleResult();
        ArrayList targetTask = new ArrayList();
        this.doJumpTask(task, request.getTargetActivityId(), t -> {
            HashMap<String, String> target = new HashMap<String, String>();
            target.put("taskId", t.getId());
            target.put("taskName", t.getName());
            target.put("activityId", t.getTaskDefinitionKey());
            targetTask.add(target);
        });
        if (request.isRecordLog()) {
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("targetTask", targetTask);
            if (request.getData() != null) {
                data.putAll(request.getData());
            }
            ProcessHistoryEntity history = ProcessHistoryEntity.builder().businessKey(processInstance.getBusinessKey()).type("jump").typeText("\u6d41\u7a0b\u8df3\u8f6c").creatorId(request.getJumpUserId()).creatorName(request.getJumpUserName()).processDefineId(processInstance.getProcessDefinitionId()).processInstanceId(processInstance.getProcessInstanceId()).taskId(task.getId()).taskDefineKey(task.getTaskDefinitionKey()).taskName(task.getName()).data(data).build();
            this.processHistoryService.insert((Object)history);
        }
    }

    @Override
    public void endProcess(String procInstId) {
    }

    @Override
    public void removeHiTask(String taskId) {
        this.historyService.deleteHistoricTaskInstance(taskId);
    }

    @Override
    public Map<String, Object> selectVariableLocalByTaskId(String taskId) {
        return this.taskService.getVariablesLocal(taskId);
    }

    @Override
    public String selectVariableLocalByTaskId(String taskId, String variableName) {
        return (String)this.taskService.getVariableLocal(taskId, variableName);
    }

    @Override
    public HistoricProcessInstance selectHisProInst(String procInstId) {
        return (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(procInstId).singleResult();
    }

    @Override
    public void setCandidate(String doingUserId, Task task) {
        if (task == null) {
            return;
        }
        if (task.getTaskDefinitionKey() != null) {
            List<CandidateInfo> candidateInfoList = this.processConfigurationService.getActivityConfiguration(doingUserId, task.getProcessDefinitionId(), task.getTaskDefinitionKey()).getCandidateInfo(task);
            if (CollectionUtils.isEmpty(candidateInfoList)) {
                this.logger.warn("\u4efb\u52a1:{}\u672a\u80fd\u8bbe\u7f6e\u5019\u9009\u4eba,\u6b64\u4efb\u52a1\u53ef\u80fd\u65e0\u6cd5\u529e\u7406!", (Object)task);
            } else {
                for (CandidateInfo candidateInfo : candidateInfoList) {
                    Authentication user = candidateInfo.user();
                    if (user == null) continue;
                    this.taskService.addCandidateUser(task.getId(), user.getUser().getId());
                }
            }
        } else {
            this.logger.warn("\u672a\u80fd\u6210\u529f\u8bbe\u7f6e\u73af\u8282\u5019\u9009\u4eba,task:{}", (Object)task);
        }
    }

    @Override
    public ActivityImpl selectActivityImplByTask(String taskId) {
        if (StringUtils.isNullOrEmpty((Object)taskId)) {
            return new ActivityImpl(null, null);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        ProcessDefinitionEntity entity = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        List activities = entity.getActivities();
        return activities.stream().filter(activity -> "userTask".equals(activity.getProperty("type")) && activity.getProperty("name").equals(task.getName())).findFirst().orElseThrow(() -> new NotFoundException("\u83b7\u53d6\u8282\u70b9\u4fe1\u606f\u5931\u8d25"));
    }

    @Override
    public Map<String, Object> getUserTasksByProcDefKey(String procDefKey) {
        String definitionId = ((ProcessDefinition)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(procDefKey).orderByProcessDefinitionVersion().desc()).list().get(0)).getId();
        List<ActivityImpl> activities = this.bpmActivityService.getUserTasksByProcDefId(definitionId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ActivityImpl activity : activities) {
            map.put(activity.getId(), activity.getProperty("name"));
        }
        return map;
    }

    @Override
    public Map<String, Object> getUserTasksByProcInstId(String procInstId) {
        String definitionId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(procInstId).singleResult()).getProcessDefinitionId();
        List<ActivityImpl> activities = this.bpmActivityService.getUserTasksByProcDefId(definitionId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ActivityImpl activity : activities) {
            map.put(activity.getId(), activity.getProperty("name"));
        }
        return map;
    }

    @Override
    public void setVariables(String taskId, Map<String, Object> map) {
        this.taskService.setVariables(taskId, map);
    }

    @Override
    public void removeVariables(String taskId, Collection<String> var2) {
        this.taskService.removeVariables(taskId, var2);
    }

    @Override
    public void setVariablesLocal(String taskId, Map<String, Object> map) {
        this.taskService.setVariablesLocal(taskId, map);
    }

    @Override
    public Map<String, Object> getVariablesByProcInstId(String procInstId) {
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(procInstId).list();
        String executionId = "";
        for (Execution execution : executions) {
            if (!StringUtils.isNullOrEmpty((Object)execution.getParentId())) continue;
            executionId = execution.getId();
        }
        return this.runtimeService.getVariables(executionId);
    }

    @Override
    public Map<String, Object> getVariablesByTaskId(String taskId) {
        return this.taskService.getVariables(taskId);
    }
}

