/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.web;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.runtime.ProcessInstanceQuery;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.hswebframework.ezorm.core.NestConditional;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.NotFoundException;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.commons.entity.PagerResult;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.workflow.service.BpmActivityService;
import org.hswebframework.web.workflow.service.BpmProcessService;
import org.hswebframework.web.workflow.service.BpmTaskService;
import org.hswebframework.web.workflow.service.WorkFlowFormService;
import org.hswebframework.web.workflow.service.config.ProcessConfigurationService;
import org.hswebframework.web.workflow.service.request.CompleteTaskRequest;
import org.hswebframework.web.workflow.service.request.JumpTaskRequest;
import org.hswebframework.web.workflow.service.request.RejectTaskRequest;
import org.hswebframework.web.workflow.service.request.StartProcessRequest;
import org.hswebframework.web.workflow.util.QueryUtils;
import org.hswebframework.web.workflow.web.response.CandidateDetail;
import org.hswebframework.web.workflow.web.response.ProcessInfo;
import org.hswebframework.web.workflow.web.response.TaskInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workflow/process"})
@Api(tags={"\u5de5\u4f5c\u6d41-\u6d41\u7a0b\u7ba1\u7406"}, description="\u5de5\u4f5c\u6d41-\u6d41\u7a0b\u7ba1\u7406")
@Authorize(permission={"workflow-process"}, description={"\u5de5\u4f5c\u6d41-\u6d41\u7a0b\u7ba1\u7406"})
public class FlowableProcessController {
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private BpmTaskService bpmTaskService;
    @Autowired
    private BpmActivityService bpmActivityService;
    @Autowired
    private BpmProcessService bpmProcessService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessConfigurationService processConfigurationService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private WorkFlowFormService workFlowFormService;

    @GetMapping(value={"/doing"})
    @Authorize(action={"query"})
    @ApiOperation(value="\u67e5\u8be2\u8fdb\u884c\u4e2d\u7684\u6d41\u7a0b\u4fe1\u606f")
    public ResponseMessage<PagerResult<ProcessInfo>> queryProcess(QueryParamEntity query) {
        ProcessInstanceQuery instanceQuery = this.runtimeService.createProcessInstanceQuery();
        PagerResult<ProcessInfo> result = QueryUtils.doQuery(instanceQuery, query, ProcessInfo::of, (term, q) -> {
            if ("status".equals(term.getColumn())) {
                switch (String.valueOf(term.getValue())) {
                    case "active": {
                        q.active();
                        break;
                    }
                    case "suspended": {
                        q.suspended();
                        break;
                    }
                }
            }
        });
        return ResponseMessage.ok(result).exclude((Collection)query.getExcludes()).include((Collection)query.getIncludes());
    }

    @GetMapping(value={"/tasks"})
    @Authorize(action={"query"})
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7684\u5386\u53f2\u4efb\u52a1\u4fe1\u606f")
    public ResponseMessage<PagerResult<TaskInfo>> getHistory(QueryParamEntity query, Authentication authentication) {
        HistoricTaskInstanceQuery historyQuery = this.historyService.createHistoricTaskInstanceQuery();
        historyQuery.taskAssignee(authentication.getUser().getId());
        PagerResult<TaskInfo> result = QueryUtils.doQuery(historyQuery, query, TaskInfo::of, (term, q) -> {
            if ("status".equals(term.getColumn())) {
                switch (String.valueOf(term.getValue())) {
                    case "finished": {
                        q.finished();
                        break;
                    }
                    case "processFinished": {
                        q.processFinished();
                        break;
                    }
                }
            }
        });
        return ResponseMessage.ok(result).exclude((Collection)query.getExcludes()).include((Collection)query.getIncludes());
    }

    @PostMapping(value={"/start/key/{defineKey}"})
    @ApiOperation(value="\u63d0\u4ea4\u8868\u5355\u6570\u636e\u5e76\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49key\u542f\u52a8\u6d41\u7a0b")
    @Authorize(merge=false)
    public ResponseMessage<String> startProcessByKey(@PathVariable String defineKey, @RequestBody Map<String, Object> data, Authentication authentication) {
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(defineKey).active().latestVersion().singleResult();
        if (null == definition) {
            throw new NotFoundException("\u6d41\u7a0b[" + defineKey + "]\u4e0d\u5b58\u5728");
        }
        this.processConfigurationService.getProcessConfiguration(definition.getId()).assertCanStartProcess(authentication.getUser().getId(), definition);
        String id = definition.getId();
        ProcessInstance instance = this.bpmProcessService.startProcessInstance(StartProcessRequest.builder().creatorId(authentication.getUser().getId()).creatorName(authentication.getUser().getName()).formData(data).processDefineId(id).build());
        return ResponseMessage.ok((Object)instance.getId());
    }

    @PostMapping(value={"/start/id/{defId}"})
    @ApiOperation(value="\u63d0\u4ea4\u8868\u5355\u6570\u636e\u5e76\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49ID\u542f\u52a8\u6d41\u7a0b")
    @Authorize(merge=false)
    public ResponseMessage<String> startProcess(@PathVariable String defId, @RequestBody Map<String, Object> data, Authentication authentication) {
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(defId).active().singleResult();
        if (null == definition) {
            throw new NotFoundException("\u6d41\u7a0b[" + defId + "]\u4e0d\u5b58\u5728");
        }
        this.processConfigurationService.getProcessConfiguration(definition.getId()).assertCanStartProcess(authentication.getUser().getId(), definition);
        ProcessInstance instance = this.bpmProcessService.startProcessInstance(StartProcessRequest.builder().creatorId(authentication.getUser().getId()).creatorName(authentication.getUser().getName()).formData(data).processDefineId(defId).build());
        return ResponseMessage.ok((Object)instance.getId());
    }

    @GetMapping(value={"/todo"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u529e\u4efb\u52a1")
    @Authorize(merge=false)
    public ResponseMessage<PagerResult<TaskInfo>> getTodoList(QueryParamEntity query, Authentication authentication) {
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        taskQuery.taskAssignee(authentication.getUser().getId());
        PagerResult<TaskInfo> result = QueryUtils.doQuery(taskQuery, query, TaskInfo::of);
        return ResponseMessage.ok(result).exclude((Collection)query.getExcludes()).include((Collection)query.getIncludes());
    }

    @GetMapping(value={"/{type}/form/{processDefineId}"})
    @ApiOperation(value="\u83b7\u53d6\u81ea\u5df1\u53ef\u67e5\u770b\u7684\u6d41\u7a0b\u8868\u5355\u6570\u636e")
    @Authorize(merge=false)
    public ResponseMessage<PagerResult<Object>> getFormData(@PathVariable Type type, @PathVariable String processDefineId, QueryParamEntity query, Authentication authentication) {
        ((NestConditional)Query.empty((QueryParam)query).nest().when(type != null, q -> type.applyQueryTerm((NestConditional<?>)q, authentication.getUser().getId()))).end();
        return ResponseMessage.ok(this.workFlowFormService.selectProcessForm(processDefineId, query));
    }

    @GetMapping(value={"/task/form/{processDefineId}/{taskDefineKey}"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u6570\u636e")
    @Authorize(merge=false)
    public ResponseMessage<PagerResult<Object>> getTaskFormData(@PathVariable String processDefineId, @PathVariable String taskDefineKey, QueryParamEntity query) {
        return ResponseMessage.ok(this.workFlowFormService.selectTaskForm(processDefineId, taskDefineKey, query));
    }

    @GetMapping(value={"/claims"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u7b7e\u6536\u4efb\u52a1")
    @Authorize(merge=false)
    public ResponseMessage<PagerResult<TaskInfo>> getClaims(QueryParamEntity query, Authentication authentication) {
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        taskQuery.taskCandidateUser(authentication.getUser().getId());
        PagerResult<TaskInfo> result = QueryUtils.doQuery(taskQuery, query, TaskInfo::of);
        return ResponseMessage.ok(result);
    }

    @GetMapping(value={"/claims-and-todo"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u7b7e\u6536\u548c\u5f85\u5904\u7406\u7684\u4efb\u52a1")
    @Authorize(merge=false)
    public ResponseMessage<PagerResult<TaskInfo>> getClaimsAndTodo(QueryParamEntity query, Authentication authentication) {
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        taskQuery.taskCandidateOrAssigned(authentication.getUser().getId());
        PagerResult<TaskInfo> result = QueryUtils.doQuery(taskQuery, query, TaskInfo::of);
        return ResponseMessage.ok(result);
    }

    @PutMapping(value={"/claim/{taskId}"})
    @ApiOperation(value="\u7b7e\u6536\u4efb\u52a1")
    @Authorize(merge=false)
    public ResponseMessage<Void> claim(@PathVariable String taskId, Authentication authentication) {
        this.bpmTaskService.claim(taskId, authentication.getUser().getId());
        return ResponseMessage.ok();
    }

    @PutMapping(value={"/complete/{taskId}"})
    @Authorize(merge=false)
    public ResponseMessage<Void> complete(@PathVariable String taskId, @RequestBody(required=false) Map<String, Object> formData, Authentication authentication) {
        this.bpmTaskService.complete(CompleteTaskRequest.builder().taskId(taskId).completeUserId(authentication.getUser().getId()).completeUserName(authentication.getUser().getName()).formData(formData).build());
        return ResponseMessage.ok();
    }

    @PutMapping(value={"/reject/{taskId}"})
    @Authorize(merge=false)
    @ApiOperation(value="\u9a73\u56de")
    public ResponseMessage<Void> reject(@PathVariable String taskId, @RequestBody Map<String, Object> data, Authentication authentication) {
        this.bpmTaskService.reject(RejectTaskRequest.builder().taskId(taskId).rejectUserId(authentication.getUser().getId()).rejectUserName(authentication.getUser().getName()).data(data).build());
        return ResponseMessage.ok();
    }

    @PutMapping(value={"/jump/{taskId}/{activityId}"})
    @Authorize(merge=false)
    @ApiOperation(value="\u6d41\u7a0b\u8df3\u8f6c")
    public ResponseMessage<Void> jump(@PathVariable String taskId, @PathVariable String activityId, @RequestBody Map<String, Object> data, Authentication authentication) {
        this.bpmTaskService.jumpTask(JumpTaskRequest.builder().taskId(taskId).targetActivityId(activityId).recordLog(true).jumpUserId(authentication.getUser().getId()).jumpUserName(authentication.getUser().getUsername()).data(data).build());
        return ResponseMessage.ok();
    }

    @PostMapping(value={"/next-task-candidate/{taskId}"})
    @Authorize(merge=false)
    public ResponseMessage<List<CandidateDetail>> candidateList(@PathVariable String taskId, @RequestBody Map<String, Object> data, Authentication authentication) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().processInstanceId(task.getProcessInstanceId()).activityId(task.getTaskDefinitionKey()).singleResult();
        execution.setTransientVariables(data);
        List<TaskDefinition> taskDefinitions = this.bpmActivityService.getNextActivities(task.getProcessDefinitionId(), task.getTaskDefinitionKey(), (DelegateExecution)execution);
        List candidates = taskDefinitions.stream().map(TaskDefinition::getKey).flatMap(key -> this.processConfigurationService.getActivityConfiguration(authentication.getUser().getId(), task.getProcessDefinitionId(), (String)key).getCandidateInfo(task).stream()).distinct().map(CandidateDetail::of).collect(Collectors.toList());
        return ResponseMessage.ok(candidates);
    }

    public static enum Type {
        claim("user-wf-claim"),
        todo("user-wf-todo"),
        completed("user-wf-completed"),
        part("user-wf-part"),
        create("is"){

            @Override
            public void applyQueryTerm(NestConditional<?> conditional, String userId) {
                conditional.accept("creatorId", this.getTermType(), (Object)userId);
            }
        }
        ,
        claimOrTodo("is"){

            @Override
            public void applyQueryTerm(NestConditional<?> conditional, String userId) {
                ((NestConditional)((NestConditional)conditional.nest().when(true, q -> claim.applyQueryTerm((NestConditional<?>)q, userId))).or().when(true, q -> todo.applyQueryTerm((NestConditional<?>)q, userId))).end();
            }
        };

        private String termType;

        public void applyQueryTerm(NestConditional<?> conditional, String userId) {
            conditional.accept("processInstanceId", this.termType, (Object)userId);
        }

        @ConstructorProperties(value={"termType"})
        private Type(String termType) {
            this.termType = termType;
        }

        public String getTermType() {
            return this.termType;
        }
    }
}

