/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.service.imp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessElementImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.engine.runtime.ProcessInstance;
import org.hswebframework.web.workflow.service.BpmActivityService;
import org.hswebframework.web.workflow.service.imp.AbstractFlowableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BpmActivityServiceImpl
extends AbstractFlowableService
implements BpmActivityService {
    @Autowired
    private ProcessEngine processEngine;

    @Override
    public ActivityImpl getActivityById(String procDefId, String activityId) {
        return this.getProcessDefinition(procDefId).findActivity(activityId);
    }

    @Override
    public List<ActivityImpl> getActivitiesByKey(String procDefKey, String activityId) {
        ProcessDefinition definition = (ProcessDefinition)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(procDefKey).orderByProcessDefinitionVersion().desc()).singleResult();
        return this.getActivitiesById(definition.getId(), activityId);
    }

    @Override
    public List<ActivityImpl> getActivitiesById(String processDefId, String activityId) {
        ProcessDefinitionEntity pde = this.getProcessDefinition(processDefId);
        if (activityId == null) {
            return pde.getActivities();
        }
        ActivityImpl activity = pde.findActivity(activityId);
        if (null == activity) {
            return new ArrayList<ActivityImpl>();
        }
        return Collections.singletonList(activity);
    }

    @Override
    public List<ActivityImpl> getUserTasksByProcDefId(String procDefId) {
        return this.findActivities(procDefId, activity -> "userTask".equals(activity.getProperty("type")));
    }

    @Override
    public List<ActivityImpl> getUserTasksByProcDefKey(String procDefKey) {
        ProcessDefinition definition = (ProcessDefinition)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(procDefKey).orderByProcessDefinitionVersion().desc()).list().get(0);
        String procDefId = definition.getId();
        List<ActivityImpl> activities = this.findActivities(procDefId, activity -> "userTask".equals(activity.getProperty("type")));
        if (null != activities) {
            activities.sort(Comparator.comparing(ProcessElementImpl::getId));
        }
        return activities;
    }

    @Override
    public List<TaskDefinition> getNextActivities(String procDefId, String activityId, DelegateExecution execution) {
        ActivityImpl activity = activityId != null ? this.getActivityById(procDefId, activityId) : this.getStartEvent(procDefId);
        List pvmTransitions = activity.getOutgoingTransitions();
        return pvmTransitions.stream().map(PvmTransition::getDestination).map(ActivityImpl.class::cast).filter(Objects::nonNull).map(act -> this.getTaskDefinition((ActivityImpl)act, execution)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<TaskDefinition> getTaskDefinition(ActivityImpl activityImpl, DelegateExecution execution) {
        HashSet<TaskDefinition> taskDefinitionList = new HashSet<TaskDefinition>();
        if ("userTask".equals(activityImpl.getProperty("type"))) {
            TaskDefinition taskDefinition = ((UserTaskActivityBehavior)activityImpl.getActivityBehavior()).getTaskDefinition();
            taskDefinitionList.add(taskDefinition);
        } else {
            List pvmTransitions = activityImpl.getOutgoingTransitions();
            for (PvmTransition tr : pvmTransitions) {
                PvmActivity pvmActivity = tr.getSource();
                boolean exclusiveGateway = "exclusiveGateway".equals(pvmActivity.getProperty("type"));
                boolean parallelGateway = "parallelGateway".equals(pvmActivity.getProperty("type"));
                if (exclusiveGateway || parallelGateway) {
                    List<TaskDefinition> nextTaskDefinition;
                    List outTransitionsTemp = pvmActivity.getOutgoingTransitions();
                    if (outTransitionsTemp.size() == 1) {
                        nextTaskDefinition = this.getTaskDefinition((ActivityImpl)((PvmTransition)outTransitionsTemp.get(0)).getDestination(), execution);
                        taskDefinitionList.addAll(nextTaskDefinition);
                        continue;
                    }
                    if (outTransitionsTemp.size() <= 1) continue;
                    for (PvmTransition transition : outTransitionsTemp) {
                        String condition = (String)transition.getProperty("conditionText");
                        if (StringUtils.isEmpty((Object)condition)) {
                            nextTaskDefinition = this.getTaskDefinition((ActivityImpl)transition.getDestination(), execution);
                            if (exclusiveGateway) {
                                if (CollectionUtils.isEmpty(nextTaskDefinition)) continue;
                                taskDefinitionList.add(nextTaskDefinition.get(0));
                                continue;
                            }
                            taskDefinitionList.addAll(nextTaskDefinition);
                            continue;
                        }
                        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
                        ExpressionManager expressionManager = ((ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration()).getExpressionManager();
                        ELContext elContext = expressionManager.getElContext((VariableScope)execution);
                        Object e = factory.createValueExpression(elContext, condition, Object.class).getValue(elContext);
                        if (!Boolean.TRUE.equals(e)) continue;
                        nextTaskDefinition = this.getTaskDefinition((ActivityImpl)transition.getDestination(), execution);
                        taskDefinitionList.addAll(nextTaskDefinition);
                    }
                    continue;
                }
                if (!"userTask".equals(pvmActivity.getProperty("type"))) continue;
                taskDefinitionList.add(((UserTaskActivityBehavior)((ActivityImpl)pvmActivity).getActivityBehavior()).getTaskDefinition());
            }
        }
        return new ArrayList<TaskDefinition>(taskDefinitionList);
    }

    @Override
    public ActivityImpl getStartEvent(String procDefId) {
        return this.findActivity(procDefId, activity -> "startEvent".equals(activity.getProperty("type")));
    }

    private List<ActivityImpl> findActivities(String procDefId, Predicate<ActivityImpl> predicate) {
        ProcessDefinitionEntity pde = this.getProcessDefinition(procDefId);
        if (pde == null) {
            return new ArrayList<ActivityImpl>();
        }
        return pde.getActivities().stream().filter(predicate).collect(Collectors.toList());
    }

    private ActivityImpl findActivity(String procDefId, Predicate<ActivityImpl> predicate) {
        ProcessDefinitionEntity pde = this.getProcessDefinition(procDefId);
        if (pde == null) {
            return null;
        }
        return pde.getActivities().stream().filter(predicate).findFirst().orElse(null);
    }

    @Override
    public ActivityImpl getEndEvent(String procDefId) {
        return this.findActivity(procDefId, activity -> "endEvent".equals(activity.getProperty("type")));
    }

    public ProcessDefinitionEntity getProcessDefinition(String procDefId) {
        return (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(procDefId);
    }

    @Override
    public ActivityImpl getActivityByProcInstId(String procDefId, String procInstId) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(procInstId).active().singleResult();
        String activityId = processInstance.getActivityId();
        return this.getProcessDefinition(procDefId).findActivity(activityId);
    }

    @Override
    public List<ActivityImpl> getNextEvent(ActivityImpl activity) {
        return activity.getOutgoingTransitions().stream().map(PvmTransition::getDestination).map(ActivityImpl.class::cast).collect(Collectors.toList());
    }
}

