/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.dimension;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.vavr.Lazy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.web.workflow.dimension.CandidateDimension;
import org.hswebframework.web.workflow.dimension.CandidateDimensionParser;
import org.hswebframework.web.workflow.dimension.DimensionContext;
import org.hswebframework.web.workflow.dimension.parser.CandidateDimensionParserStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DefaultCandidateDimensionParser
implements CandidateDimensionParser {
    @Autowired(required=false)
    private List<CandidateDimensionParserStrategy> strategies;

    private CandidateDimension parse(DimensionContext context, JSONArray jsonConfig) {
        List configList = jsonConfig.stream().filter(json -> json instanceof JSONObject).map(JSONObject.class::cast).filter(json -> json.get((Object)"dimension") != null && CollectionUtils.isNotEmpty((Collection)json.getJSONArray("idList"))).map(json -> {
            CandidateDimensionParserStrategy.StrategyConfig config = (CandidateDimensionParserStrategy.StrategyConfig)json.toJavaObject(CandidateDimensionParserStrategy.StrategyConfig.class);
            if (config.getConfig() == null) {
                config.setConfig((Map<String, Object>)json);
            }
            return config;
        }).collect(Collectors.toList());
        if (configList.isEmpty()) {
            return CandidateDimension.empty;
        }
        return (CandidateDimension)Lazy.val(() -> {
            List list = configList.stream().flatMap(config -> this.strategies.stream().filter(strategy -> strategy.support(config.getDimension())).map(strategy -> strategy.parse(context, (CandidateDimensionParserStrategy.StrategyConfig)config)).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).filter(StringUtils::hasText)).collect(Collectors.toList());
            return () -> list;
        }, CandidateDimension.class);
    }

    @Override
    public CandidateDimension parse(DimensionContext context, String jsonConfig) {
        JSONArray jsonArray;
        if (jsonConfig.startsWith("[")) {
            jsonArray = JSON.parseArray((String)jsonConfig);
        } else {
            JSONObject jsonObject = JSON.parseObject((String)jsonConfig);
            jsonArray = new JSONArray();
            jsonArray.add((Object)jsonObject);
        }
        return this.parse(context, jsonArray);
    }
}

