/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.service.imp;

import java.util.Date;
import java.util.Objects;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.dao.CrudDao;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.EnableCacheGenericEntityService;
import org.hswebframework.web.workflow.dao.ProcessDefineConfigDao;
import org.hswebframework.web.workflow.dao.entity.ProcessDefineConfigEntity;
import org.hswebframework.web.workflow.service.ProcessDefineConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"process-config"})
public class ProcessDefineConfigServiceImpl
extends EnableCacheGenericEntityService<ProcessDefineConfigEntity, String>
implements ProcessDefineConfigService {
    @Autowired
    private ProcessDefineConfigDao processDefineConfigDao;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public CrudDao<ProcessDefineConfigEntity, String> getDao() {
        return this.processDefineConfigDao;
    }

    @Caching(evict={@CacheEvict(key="'define-id:'+#entity.processDefineId"), @CacheEvict(key="'define-key-latest:'+#entity.processDefineKey")})
    public String insert(ProcessDefineConfigEntity entity) {
        entity.setCreateTime(new Date());
        entity.setUpdateTime(new Date());
        entity.setStatus(DataStatus.STATUS_ENABLED);
        return (String)super.insert((GenericEntity)entity);
    }

    @Caching(evict={@CacheEvict(key="'define-id:'+#entity.processDefineId"), @CacheEvict(key="'define-key-latest:'+#entity.processDefineKey")})
    public int updateByPk(String id, ProcessDefineConfigEntity entity) {
        entity.setUpdateTime(new Date());
        return super.updateByPk((Object)id, (GenericEntity)entity);
    }

    @Caching(evict={@CacheEvict(key="'define-id:'+#entity.processDefineId"), @CacheEvict(key="'define-key-latest:'+#entity.processDefineKey")})
    protected int updateByPk(ProcessDefineConfigEntity entity) {
        return super.updateByPk((GenericEntity)entity);
    }

    @Caching(evict={@CacheEvict(key="'define-id:'+#entity.processDefineId"), @CacheEvict(key="'define-key-latest:'+#entity.processDefineKey")})
    public String saveOrUpdate(ProcessDefineConfigEntity entity) {
        return (String)super.saveOrUpdate((GenericEntity)entity);
    }

    @Caching(evict={@CacheEvict(key="'define-id:'+#result.processDefineId"), @CacheEvict(key="'define-key-latest:'+#result.processDefineKey")})
    public ProcessDefineConfigEntity deleteByPk(String id) {
        return (ProcessDefineConfigEntity)super.deleteByPk((Object)id);
    }

    @Override
    @Cacheable(key="'define-id:'+#processDefineId")
    public ProcessDefineConfigEntity selectByProcessDefineId(String processDefineId) {
        return (ProcessDefineConfigEntity)((Object)((Query)this.createQuery().where("processDefineId", (Object)Objects.requireNonNull(processDefineId, "\u53c2\u6570[processDefineId]\u4e0d\u80fd\u4e3a\u7a7a"))).single());
    }

    @Override
    @Cacheable(key="'define-key-latest:'+#processDefineKey")
    public ProcessDefineConfigEntity selectByLatestProcessDefineKey(String processDefineKey) {
        return (ProcessDefineConfigEntity)((Object)((Query)((Query)this.createQuery().where("processDefineKey", (Object)Objects.requireNonNull(processDefineKey, "\u53c2\u6570[processDefineKey]\u4e0d\u80fd\u4e3a\u7a7a"))).and("status", (Object)DataStatus.STATUS_ENABLED)).orderByDesc("updateTime").single());
    }
}

