/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.service.imp;

import java.util.Date;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.dao.CrudDao;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.GenericEntityService;
import org.hswebframework.web.workflow.dao.ActivityConfigDao;
import org.hswebframework.web.workflow.dao.entity.ActivityConfigEntity;
import org.hswebframework.web.workflow.service.ActivityConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"process-activity-config"})
public class ActivityConfigServiceImpl
extends GenericEntityService<ActivityConfigEntity, String>
implements ActivityConfigService {
    @Autowired
    private ActivityConfigDao activityConfigDao;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public CrudDao<ActivityConfigEntity, String> getDao() {
        return this.activityConfigDao;
    }

    @Caching(evict={@CacheEvict(key="'define-id:'+#entity.processDefineId+'-'+#entity.activityId"), @CacheEvict(key="'define-key:'+#entity.processDefineKey+'-'+#entity.activityId")})
    public String insert(ActivityConfigEntity entity) {
        entity.setCreateTime(new Date());
        entity.setUpdateTime(new Date());
        entity.setStatus(DataStatus.STATUS_ENABLED);
        return (String)super.insert((GenericEntity)entity);
    }

    @Caching(evict={@CacheEvict(key="'define-id:'+#entity.processDefineId+'-'+#entity.activityId"), @CacheEvict(key="'define-key:'+#entity.processDefineKey+'-'+#entity.activityId")})
    public int updateByPk(String pk, ActivityConfigEntity entity) {
        entity.setUpdateTime(new Date());
        return super.updateByPk((Object)pk, (GenericEntity)entity);
    }

    @Caching(evict={@CacheEvict(key="'define-id:'+#entity.processDefineId+'-'+#entity.activityId"), @CacheEvict(key="'define-key:'+#entity.processDefineKey+'-'+#entity.activityId")})
    protected int updateByPk(ActivityConfigEntity entity) {
        return super.updateByPk((GenericEntity)entity);
    }

    @Caching(evict={@CacheEvict(key="'define-id:'+#entity.processDefineId+'-'+#entity.activityId"), @CacheEvict(key="'define-key:'+#entity.processDefineKey+'-'+#entity.activityId")})
    public String saveOrUpdate(ActivityConfigEntity entity) {
        return (String)super.saveOrUpdate((GenericEntity)entity);
    }

    @Caching(evict={@CacheEvict(key="'define-id:'+#result.processDefineId+'-'+#result.activityId", condition="#result!=null"), @CacheEvict(key="'define-key:'+#result.processDefineKey+'-'+#result.activityId", condition="#result!=null")})
    public ActivityConfigEntity deleteByPk(String id) {
        return (ActivityConfigEntity)super.deleteByPk((Object)id);
    }

    @Override
    @Cacheable(key="'define-id:'+#processDefineId+'-'+#activityId")
    public ActivityConfigEntity selectByProcessDefineIdAndActivityId(String processDefineId, String activityId) {
        return (ActivityConfigEntity)((Object)((Query)((Query)this.createQuery().where("processDefineId", (Object)processDefineId)).and("activityId", (Object)activityId)).single());
    }

    @Override
    @Cacheable(key="'define-key:'+#processDefineKey+'-'+#activityId")
    public ActivityConfigEntity selectByProcessDefineKeyAndActivityId(String processDefineKey, String activityId) {
        return (ActivityConfigEntity)((Object)((Query)((Query)this.createQuery().where("processDefineKey", (Object)processDefineKey)).and("activityId", (Object)activityId)).single());
    }
}

