/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.web.response;

import java.util.ArrayList;
import java.util.List;
import org.hswebframework.web.commons.bean.Bean;
import org.hswebframework.web.organizational.authorization.Position;
import org.hswebframework.web.workflow.service.config.CandidateInfo;

public class CandidateDetail
implements Bean {
    private static final long serialVersionUID = 7568237438666348299L;
    private String userId;
    private String personId;
    private String name;
    private List<Position> positions;

    public static CandidateDetail of(CandidateInfo candidateInfo) {
        CandidateDetail detail = new CandidateDetail();
        if (candidateInfo.user() != null) {
            detail.setName(candidateInfo.user().getUser().getName());
            detail.setUserId(candidateInfo.user().getUser().getId());
        }
        if (candidateInfo.person() != null) {
            detail.setPersonId(candidateInfo.person().getPersonnel().getId());
            detail.setName(candidateInfo.person().getPersonnel().getName());
            detail.setPositions(new ArrayList<Position>(candidateInfo.person().getPositions()));
        }
        return detail;
    }

    public int hashCode() {
        return this.userId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CandidateDetail) {
            return ((CandidateDetail)obj).getUserId().equals(this.userId);
        }
        return super.equals(obj);
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getName() {
        return this.name;
    }

    public List<Position> getPositions() {
        return this.positions;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPositions(List<Position> positions) {
        this.positions = positions;
    }
}

