/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.util;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.activiti.engine.query.Query;
import org.hswebframework.ezorm.core.param.Sort;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.commons.entity.PagerResult;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class QueryUtils {
    private static final Logger log = LoggerFactory.getLogger(QueryUtils.class);

    public static <U, T extends Query<?, U>> PagerResult<U> doQuery(T query, QueryParamEntity entity) {
        return QueryUtils.doQuery(query, entity, Function.identity());
    }

    public static <U, R, T extends Query<?, U>> PagerResult<R> doQuery(T query, QueryParamEntity entity, Function<U, R> mapping) {
        return QueryUtils.doQuery(query, entity, mapping, (term, tuQuery) -> log.warn("\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u6761\u4ef6:{} {}", (Object)term.getTermType(), (Object)term.getColumn()));
    }

    public static <U, R, T extends Query<?, U>> PagerResult<R> doQuery(T query, QueryParamEntity entity, Function<U, R> mapping, BiConsumer<Term, T> notFound) {
        QueryUtils.applyQueryParam(query, entity, notFound);
        int total = (int)query.count();
        if (total == 0) {
            return PagerResult.empty();
        }
        entity.rePaging(total);
        List list = query.listPage(entity.getPageIndex(), entity.getPageSize() * (entity.getPageIndex() + 1)).stream().map(mapping).filter(Objects::nonNull).collect(Collectors.toList());
        return PagerResult.of((int)total, list);
    }

    public static <U, T extends Query<?, U>> void applyQueryParam(T query, QueryParamEntity entity, BiConsumer<Term, T> notFound) {
        String name;
        Class<?> type = query.getClass();
        for (Term term : entity.getTerms()) {
            name = term.getColumn();
            if ("like".equals(term.getTermType())) {
                name = name.concat("Like");
            } else if ("in".equals(term.getTermType())) {
                name = name.concat("s");
            }
            String finalName = name;
            AtomicBoolean found = new AtomicBoolean(false);
            ReflectionUtils.doWithMethods(type, method -> {
                if (method.getParameterCount() == 1 && (method.getName().equals(finalName) || method.getName().equals(term.getColumn()))) {
                    Object value = FastBeanCopier.DEFAULT_CONVERT.convert(term.getValue(), method.getParameterTypes()[0], FastBeanCopier.EMPTY_CLASS_ARRAY);
                    ReflectionUtils.invokeMethod((Method)method, (Object)query, (Object[])new Object[]{value});
                    found.set(true);
                }
            });
            if (found.get()) continue;
            notFound.accept(term, (Term)query);
        }
        for (Sort sort : entity.getSorts()) {
            name = sort.getName();
            Method method2 = ReflectionUtils.findMethod(type, (String)("orderBy" + StringUtils.toUpperCaseFirstOne((String)name)));
            if (method2 == null || method2.getParameterCount() != 0) continue;
            ReflectionUtils.invokeMethod((Method)method2, query);
            if ("asc".equals(sort.getOrder())) {
                query.asc();
                continue;
            }
            query.desc();
        }
    }
}

