/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.workflow.dimension.parser;

import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.service.authorization.UserService;
import org.hswebframework.web.workflow.dimension.DimensionContext;
import org.hswebframework.web.workflow.dimension.parser.CandidateDimensionParserStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(value={UserService.class})
public class RoleCandidateDimensionParserStrategy
implements CandidateDimensionParserStrategy {
    @Autowired(required=false)
    private UserService userService;

    @Override
    public boolean support(String dimension) {
        return "role".equals(dimension) && this.userService != null;
    }

    @Override
    public List<String> parse(DimensionContext context, CandidateDimensionParserStrategy.StrategyConfig config) {
        return this.userService.selectByUserByRole(config.getIdList()).stream().map(GenericEntity::getId).collect(Collectors.toList());
    }
}

