/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.controller.schedule;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.controller.SimpleGenericEntityController;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.entity.schedule.ScheduleJobEntity;
import org.hswebframework.web.service.schedule.ScheduleJobExecutor;
import org.hswebframework.web.service.schedule.ScheduleJobService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${hsweb.web.mappings.scheduleJob:schedule/job}"})
@Authorize(permission={"schedule-job"}, description={"\u5b9a\u65f6\u8c03\u5ea6\u7ba1\u7406"})
@Api(value="\u5b9a\u65f6\u8c03\u5ea6\u7ba1\u7406", tags={"\u5b9a\u65f6\u8c03\u5ea6\u7ba1\u7406"})
public class ScheduleJobController
implements SimpleGenericEntityController<ScheduleJobEntity, String, QueryParamEntity> {
    private ScheduleJobService scheduleJobService;
    private ScheduleJobExecutor scheduleJobExecutor;

    @Autowired
    @Authorize(ignore=true)
    public void setScheduleJobExecutor(ScheduleJobExecutor scheduleJobExecutor) {
        this.scheduleJobExecutor = scheduleJobExecutor;
    }

    @Autowired
    @Authorize(ignore=true)
    public void setScheduleJobService(ScheduleJobService scheduleJobService) {
        this.scheduleJobService = scheduleJobService;
    }

    public ScheduleJobService getService() {
        return this.scheduleJobService;
    }

    @PutMapping(value={"/{id}/enable"})
    @Authorize(action={"enable"})
    @ApiOperation(value="\u542f\u7528\u4efb\u52a1")
    public ResponseMessage<Void> enable(@PathVariable String id) {
        this.scheduleJobService.enable(id);
        return ResponseMessage.ok();
    }

    @PutMapping(value={"/{id}/disable"})
    @Authorize(action={"disable"})
    @ApiOperation(value="\u7981\u7528\u4efb\u52a1")
    public ResponseMessage<Void> disable(@PathVariable String id) {
        this.scheduleJobService.disable(id);
        return ResponseMessage.ok();
    }

    @PostMapping(value={"/{id}/execute"})
    @Authorize(action={"execute"}, description={"\u6267\u884c\u4efb\u52a1"})
    @ApiOperation(value="\u6267\u884c\u4efb\u52a1")
    public ResponseMessage<Object> execute(@PathVariable String id, @RequestBody Map<String, Object> args) {
        return ResponseMessage.ok((Object)this.scheduleJobExecutor.doExecuteJob(id, args));
    }
}

