/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.schedule.configuration;

import java.util.Map;
import javax.sql.DataSource;
import org.hswebframework.web.schedule.configuration.AutoCreateTable;
import org.hswebframework.web.schedule.configuration.SchedulerProperties;
import org.hswebframework.web.service.schedule.ScheduleJobExecutor;
import org.hswebframework.web.service.schedule.ScheduleJobService;
import org.hswebframework.web.service.schedule.simple.DefaultScriptScheduleJobExecutor;
import org.hswebframework.web.service.schedule.simple.DynamicJobFactory;
import org.quartz.Calendar;
import org.quartz.Scheduler;
import org.quartz.SchedulerListener;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.AdaptableJobFactory;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableConfigurationProperties(value={SchedulerProperties.class})
@ConditionalOnMissingBean(value={Scheduler.class, SchedulerFactoryBean.class})
@ComponentScan(value={"org.hswebframework.web.service.schedule.simple", "org.hswebframework.web.controller.schedule"})
public class ScheduleAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ScheduleAutoConfiguration.class);
    @Autowired
    private SchedulerProperties schedulerProperties;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private PlatformTransactionManager platformTransactionManager;
    @Autowired(required=false)
    private Map<String, Calendar> calendarMap;
    @Autowired(required=false)
    private SchedulerListener[] schedulerListeners;

    @Bean
    public JobFactory jobFactory() {
        return new DynamicJobFactory((JobFactory)new AdaptableJobFactory());
    }

    @Bean
    public AutoCreateTable autoCreateTable() {
        return new AutoCreateTable();
    }

    @Bean
    public SchedulerFactoryBean schedulerFactory(JobFactory jobFactory) {
        SchedulerFactoryBean schedulerFactoryBean = new SchedulerFactoryBean();
        schedulerFactoryBean.setApplicationContext(this.applicationContext);
        schedulerFactoryBean.setAutoStartup(this.schedulerProperties.isAutoStartup());
        schedulerFactoryBean.setDataSource(this.dataSource);
        schedulerFactoryBean.setTransactionManager(this.platformTransactionManager);
        schedulerFactoryBean.setOverwriteExistingJobs(this.schedulerProperties.isOverwriteExistingJobs());
        schedulerFactoryBean.setSchedulerFactoryClass(StdSchedulerFactory.class);
        schedulerFactoryBean.setBeanName(this.schedulerProperties.getBeanName());
        schedulerFactoryBean.setJobFactory(jobFactory);
        schedulerFactoryBean.setWaitForJobsToCompleteOnShutdown(this.schedulerProperties.isWaitOnShutdown());
        schedulerFactoryBean.setQuartzProperties(this.schedulerProperties.getProperties());
        schedulerFactoryBean.setStartupDelay(this.schedulerProperties.getStartupDelay());
        schedulerFactoryBean.setCalendars(this.calendarMap);
        schedulerFactoryBean.setSchedulerListeners(this.schedulerListeners);
        return schedulerFactoryBean;
    }

    @Bean
    @ConditionalOnMissingBean(value={ScheduleJobExecutor.class})
    public ScheduleJobExecutor scheduleJobExecutor(ScheduleJobService scheduleJobService) {
        DefaultScriptScheduleJobExecutor defaultExecutor = new DefaultScriptScheduleJobExecutor(scheduleJobService);
        return defaultExecutor;
    }
}

