/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.schedule.configuration;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.utils.file.FileUtils;
import org.hswebframework.web.Sqls;
import org.hswebframework.web.datasource.DataSourceHolder;
import org.hswebframework.web.datasource.DatabaseType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

@Order(value=-2147483648)
public class AutoCreateTable
implements CommandLineRunner {
    @Autowired
    private SqlExecutor sqlExecutor;

    public void run(String ... args) throws Exception {
        Resource[] resources;
        if (this.sqlExecutor.tableExists("QRTZ_LOCKS")) {
            return;
        }
        DatabaseType databaseType = DataSourceHolder.currentDatabaseType();
        String databaseTypeName = databaseType.name();
        if (databaseType == DatabaseType.jtds_sqlserver) {
            databaseTypeName = DatabaseType.sqlserver.name();
        }
        String file = "classpath*:/quartz/sql/quartz-" + databaseTypeName + "-create.sql";
        for (Resource resource : resources = new PathMatchingResourcePatternResolver().getResources(file)) {
            try (InputStreamReader reader = new InputStreamReader(resource.getInputStream());){
                String str = FileUtils.reader2String((Reader)reader);
                List sqlList = Sqls.parse((String)str);
                for (String sql : sqlList) {
                    if (StringUtils.isEmpty((Object)sql)) {
                        return;
                    }
                    this.sqlExecutor.exec(sql);
                }
            }
        }
    }
}

