/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.schedule.simple;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.hswebframework.ezorm.core.dsl.Update;
import org.hswebframework.web.BusinessException;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.dao.schedule.ScheduleJobDao;
import org.hswebframework.web.entity.schedule.ScheduleJobEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.GenericEntityService;
import org.hswebframework.web.service.schedule.ScheduleJobService;
import org.hswebframework.web.service.schedule.ScheduleTriggerBuilder;
import org.hswebframework.web.service.schedule.simple.DynamicJob;
import org.quartz.Calendar;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.spi.MutableTrigger;
import org.quartz.spi.OperableTrigger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="scheduleJobService")
public class SimpleScheduleJobService
extends GenericEntityService<ScheduleJobEntity, String>
implements ScheduleJobService {
    @Autowired
    private ScheduleJobDao scheduleJobDao;
    @Autowired
    protected Scheduler scheduler;
    @Autowired
    private ScheduleTriggerBuilder scheduleTriggerBuilder;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public ScheduleJobDao getDao() {
        return this.scheduleJobDao;
    }

    public static List<Date> computeFireTimesBetween(OperableTrigger trigger, Calendar cal, Date from, Date to, int num) {
        Date d;
        LinkedList<Date> lst = new LinkedList<Date>();
        OperableTrigger t = (OperableTrigger)trigger.clone();
        if (t.getNextFireTime() == null) {
            t.setStartTime(from);
            t.setEndTime(to);
            t.computeFirstFireTime(cal);
        }
        for (int i = 0; i < num && (d = t.getNextFireTime()) != null; ++i) {
            if (d.before(from)) {
                t.triggered(cal);
                continue;
            }
            if (d.after(to)) break;
            lst.add(d);
            t.triggered(cal);
        }
        return lst;
    }

    protected void startJob(ScheduleJobEntity jobEntity) {
        try {
            if (this.scheduler.checkExists(this.createJobKey(jobEntity))) {
                return;
            }
            JobDetail jobDetail = JobBuilder.newJob(DynamicJob.class).withIdentity(this.createJobKey(jobEntity)).setJobData(this.createJobDataMap(jobEntity.getParameters())).usingJobData("dynamic-job-id:", (String)jobEntity.getId()).withDescription(jobEntity.getName() + (jobEntity.getRemark() == null ? "" : jobEntity.getRemark())).build();
            MutableTrigger trigger = this.scheduleTriggerBuilder.buildTrigger(jobEntity.getQuartzConfig());
            trigger.setKey(this.createTriggerKey(jobEntity));
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            throw new BusinessException("\u542f\u52a8\u5b9a\u65f6\u8c03\u5ea6\u5931\u8d25", (Throwable)e);
        }
    }

    protected JobDataMap createJobDataMap(String parameters) {
        JobDataMap map = new JobDataMap();
        if (!StringUtils.isEmpty((Object)parameters)) {
            JSONArray jsonArray = JSON.parseArray((String)parameters);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject o = jsonArray.getJSONObject(i);
                map.put(o.getString("key"), o.get((Object)"value"));
            }
        }
        return map;
    }

    protected JobKey createJobKey(ScheduleJobEntity jobEntity) {
        String group = jobEntity.getType() == null ? "hsweb.scheduler" : jobEntity.getType();
        return new JobKey((String)jobEntity.getId(), group);
    }

    protected TriggerKey createTriggerKey(ScheduleJobEntity jobEntity) {
        String group = jobEntity.getType() == null ? "hsweb.scheduler" : jobEntity.getType();
        return new TriggerKey((String)jobEntity.getId(), group);
    }

    public void enable(String id) {
        Objects.requireNonNull(id);
        int size = ((Update)this.createUpdate().set("status", (Object)DataStatus.STATUS_ENABLED).where("id", (Object)id)).exec();
        if (size > 0) {
            this.startJob((ScheduleJobEntity)this.selectByPk(id));
        }
    }

    private void deleteJob(ScheduleJobEntity jobEntity) {
        JobKey jobKey = this.createJobKey(jobEntity);
        try {
            if (this.scheduler.checkExists(jobKey)) {
                this.scheduler.deleteJob(jobKey);
            }
        }
        catch (SchedulerException e) {
            throw new BusinessException("\u66f4\u65b0\u4efb\u52a1\u5931\u8d25", (Throwable)e, 500);
        }
    }

    public void disable(String id) {
        Objects.requireNonNull(id);
        int size = ((Update)this.createUpdate().set("status", (Object)DataStatus.STATUS_DISABLED).where("id", (Object)id)).exec();
        if (size > 0) {
            this.deleteJob((ScheduleJobEntity)this.selectByPk(id));
        }
    }
}

