/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.schedule.simple;

import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.expands.script.engine.DynamicScriptEngine;
import org.hswebframework.expands.script.engine.DynamicScriptEngineFactory;
import org.hswebframework.web.entity.schedule.ScheduleJobEntity;
import org.hswebframework.web.service.schedule.ScheduleJobExecutor;
import org.hswebframework.web.service.schedule.ScheduleJobService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DefaultScriptScheduleJobExecutor
implements ScheduleJobExecutor {
    private ScheduleJobService scheduleJobService;

    public DefaultScriptScheduleJobExecutor() {
    }

    public DefaultScriptScheduleJobExecutor(ScheduleJobService scheduleJobService) {
        this.scheduleJobService = scheduleJobService;
    }

    @Autowired
    public void setScheduleJobService(ScheduleJobService scheduleJobService) {
        this.scheduleJobService = scheduleJobService;
    }

    @Transactional(rollbackFor={Throwable.class})
    public Object doExecuteJob(String jobId, Map<String, Object> parameter) {
        try {
            ScheduleJobEntity jobEntity = (ScheduleJobEntity)this.scheduleJobService.selectByPk((Object)jobId);
            if (null == jobEntity) {
                return null;
            }
            DynamicScriptEngine engine = DynamicScriptEngineFactory.getEngine((String)jobEntity.getLanguage());
            String jobMd5 = DigestUtils.md5Hex((String)jobEntity.getScript());
            if (engine.getContext(jobId) == null || !jobMd5.equals(engine.getContext(jobId).getMd5())) {
                engine.compile(jobId, jobEntity.getScript());
            }
            return engine.execute(jobId, parameter).getIfSuccess();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

