/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.schedule.simple;

import java.util.Map;
import org.hswebframework.web.service.schedule.ScheduleJobExecutor;
import org.hswebframework.web.service.schedule.simple.DynamicJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.factory.annotation.Autowired;

public class DynamicJobFactory
implements JobFactory {
    public static final String JOB_ID_KEY = "dynamic-job-id:";
    private JobFactory defaultFactory;
    private ScheduleJobExecutor scheduleJobExecutor;

    public DynamicJobFactory(JobFactory defaultFactory) {
        this.defaultFactory = defaultFactory;
    }

    @Autowired
    public void setScheduleJobExecutor(ScheduleJobExecutor scheduleJobExecutor) {
        this.scheduleJobExecutor = scheduleJobExecutor;
    }

    public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
        JobDataMap data = bundle.getJobDetail().getJobDataMap();
        String jobId = (String)data.get(JOB_ID_KEY);
        if (null == jobId || bundle.getJobDetail().getJobClass() != DynamicJob.class) {
            return this.defaultFactory.newJob(bundle, scheduler);
        }
        return arg_0 -> this.lambda$newJob$0(jobId, (Map)data, arg_0);
    }

    private /* synthetic */ void lambda$newJob$0(String jobId, Map data, JobExecutionContext context) throws JobExecutionException {
        this.scheduleJobExecutor.doExecuteJob(jobId, data);
    }
}

