/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.controller.organizational;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.hswebframework.web.NotFoundException;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.RequiresDataAccess;
import org.hswebframework.web.authorization.define.Phased;
import org.hswebframework.web.commons.entity.Entity;
import org.hswebframework.web.commons.entity.PagerResult;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.controller.SimpleGenericEntityController;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.entity.organizational.PersonAuthBindEntity;
import org.hswebframework.web.entity.organizational.PersonEntity;
import org.hswebframework.web.organizational.authorization.PersonnelAuthentication;
import org.hswebframework.web.organizational.authorization.PersonnelAuthenticationHolder;
import org.hswebframework.web.service.organizational.PersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${hsweb.web.mappings.person:person}"})
@Authorize(permission={"person"}, description={"\u4eba\u5458\u7ba1\u7406"}, dataAccess=@RequiresDataAccess)
@Api(value="\u4eba\u5458\u7ba1\u7406", tags={"\u7ec4\u7ec7\u67b6\u6784-\u4eba\u5458\u7ba1\u7406"})
public class PersonController
implements SimpleGenericEntityController<PersonEntity, String, QueryParamEntity> {
    private PersonService personService;

    @Autowired
    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public PersonService getService() {
        return this.personService;
    }

    public ResponseMessage<PagerResult<PersonEntity>> list(QueryParamEntity param) {
        return super.list((Entity)param);
    }

    @GetMapping(value={"/me"})
    @ApiOperation(value="\u67e5\u770b\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u4eba\u5458\u4fe1\u606f")
    @Authorize(merge=false)
    public ResponseMessage<PersonAuthBindEntity> getLoginUserPerson() {
        PersonnelAuthentication authorization = (PersonnelAuthentication)PersonnelAuthentication.current().orElseThrow(NotFoundException::new);
        return this.getDetail(authorization.getPersonnel().getId());
    }

    @PutMapping(value={"/me"})
    @ApiOperation(value="\u4fee\u6539\u4e2a\u4eba\u4fe1\u606f")
    @Authorize(merge=false)
    public ResponseMessage<String> updateMePersonInfo(@RequestBody PersonAuthBindEntity bindEntity) {
        PersonnelAuthentication authorization = (PersonnelAuthentication)PersonnelAuthentication.current().orElseThrow(NotFoundException::new);
        PersonAuthBindEntity old = this.personService.selectAuthBindByPk(authorization.getPersonnel().getId());
        bindEntity.setUserId(old.getUserId());
        bindEntity.setId(old.getId());
        bindEntity.setPositionIds(null);
        if (bindEntity.getPersonUser() != null) {
            bindEntity.getPersonUser().setUsername(old.getPersonUser().getUsername());
        }
        this.personService.updateByPk(bindEntity);
        return ResponseMessage.ok();
    }

    @GetMapping(value={"/me/authorization"})
    @ApiOperation(value="\u67e5\u770b\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u4eba\u5458\u6743\u9650\u4fe1\u606f")
    @Authorize(merge=false)
    public ResponseMessage<PersonnelAuthentication> getLoginUserPersonDetail() {
        PersonnelAuthentication authorization = (PersonnelAuthentication)PersonnelAuthentication.current().orElseThrow(NotFoundException::new);
        return ResponseMessage.ok((Object)authorization);
    }

    @GetMapping(value={"/{personId}/authorization"})
    @ApiOperation(value="\u67e5\u770b\u4eba\u5458\u6743\u9650\u4fe1\u606f")
    @Authorize(action={"get"}, dataAccess=@RequiresDataAccess(ignore=true))
    public ResponseMessage<PersonnelAuthentication> getPersonDetail(@PathVariable String personId) {
        return ResponseMessage.ok((Object)PersonnelAuthenticationHolder.getByPersonId((String)personId));
    }

    @GetMapping(value={"/{id}/detail"})
    @ApiOperation(value="\u67e5\u770b\u4eba\u5458\u8be6\u60c5")
    @Authorize(action={"get"}, dataAccess=@RequiresDataAccess(phased=Phased.after))
    public ResponseMessage<PersonAuthBindEntity> getDetail(@PathVariable String id) {
        return ResponseMessage.ok((Object)this.personService.selectAuthBindByPk(id));
    }

    @PostMapping(value={"/detail"})
    @ApiOperation(value="\u65b0\u589e\u4eba\u5458\u4fe1\u606f,\u5e76\u5173\u8054\u7528\u6237\u4fe1\u606f")
    @Authorize(action={"add"}, dataAccess=@RequiresDataAccess(ignore=true))
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseMessage<String> createPersonDetail(@RequestBody PersonAuthBindEntity bindEntity) {
        return ResponseMessage.ok((Object)this.personService.insert(bindEntity));
    }

    @PutMapping(value={"/{id}/detail"})
    @ApiOperation(value="\u4fee\u6539\u4eba\u5458\u4fe1\u606f,\u5e76\u5173\u8054\u7528\u6237\u4fe1\u606f")
    @Authorize(action={"update"}, dataAccess=@RequiresDataAccess(ignore=true))
    public ResponseMessage<String> getDetail(@PathVariable String id, @RequestBody PersonAuthBindEntity bindEntity) {
        bindEntity.setId((Object)id);
        this.personService.updateByPk(bindEntity);
        return ResponseMessage.ok();
    }

    @GetMapping(value={"/in-position/{positionId}"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u5c97\u4f4d\u7684\u4eba\u5458")
    @Authorize(action={"get"}, dataAccess=@RequiresDataAccess(phased=Phased.after))
    public ResponseMessage<List<PersonEntity>> getByPositionId(@PathVariable String positionId) {
        return ResponseMessage.ok((Object)this.personService.selectByPositionId(positionId));
    }
}

